<?php

    namespace App\Http\Controllers\Administrator\Item;

    use App\Http\Controllers\Controller;
    use App\Model\product\UnitModel;
    use Carbon\Carbon;
    use Illuminate\Http\Request;
    use Validator;
    use Yajra\DataTables\DataTables;
    use Auth;

    class UnitController extends Controller
    {
        function __construct()
        {
            $this->middleware('permission:Unit List', ['only' => ['index']]);
            $this->middleware('permission:Unit Create', ['only' => ['create', 'store']]);
            $this->middleware('permission:Unit Edit', ['only' => ['update', 'edit']]);
//            $this->middleware('permission:Unit Delete', ['only' => ['index']]);
        }

        public function index(Request $request)
        {
            if ($request['delete']) {
                UnitModel::find($request['delete'])->delete();
                return response()->json(['status' => 'ok']);
            }
            if ($request->ajax()) {
                $data = UnitModel::latest()
                    ->take(20);
                $count = $data->count();
                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count,
                    ])
                    ->addColumn('action', function ($action) {
                        $btn = '';
                        if (uCan('Unit Edit')) {
                            $btn .= '<a data-href = "' . route("unit.edit", $action->id) . '"  data-name="' .__('administrator.edit') . '" class="getHtmlForm fa fa-pencil btn btn-warning" title="' . __('administrator.edit') . '"></a>';
                        }
                        if (uCan('Unit Delete')) {
                            $btn .= ' <a data-href = "' . route("unit.index") . '?delete=' . $action->id . '" class="btn_delete fa fa-trash btn btn-danger" title="' . __('administrator.delete') . '"></a>';
                        }
                        return $btn;
                    })
                    ->editColumn('created_at', function ($action) {
                        return Carbon::parse($action->created_at)->format('d-m-Y');
                    })
                    ->addIndexColumn()
                    ->rawColumns(['action'])
                    ->make(true);
            }
            return view('administrator.item-setup.unit.index');
        }

        public function create()
        {
            return view('administrator.item-setup.unit.create');
        }

        public function edit($id)
        {
            $master = UnitModel::find($id);
            return view('administrator.item-setup.unit.edit', compact('master'));
        }

        public function store(Request $request)
        {
            return $this->update($request, null);
        }

        public function update(Request $request, $id)
        {
            $this->validate($request, [
                'unit' => 'required|min:1|max:50|string|unique:nso007_unit,unit,' . $id,
                'note' => 'nullable|string|max:255',
            ]);
            $master = UnitModel::updateOrCreate(['id' => $id], $request->all());
            if($request['input_name']){
                return response()->json(['value'=>$master->id,'text'=>$master->unit,'input_name'=>$request['input_name']]);// if create in other page
            }
            return response()->json('ok');
        }
    }
