<?php


    namespace App\Http\Controllers\Administrator\Item;

    use App\Fun\Fun;
    use App\Http\Controllers\Controller;
    use App\Model\product\ShelfModel;
    use App\Model\ProductModel;
    use App\Model\ProductUnitModel;
    use App\Model\StockModel;
    use Carbon\Carbon;
    use DataTables;
    use DB;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Auth;
    use Image;

    class ProductController extends Controller

    {
        function __construct()
        {
            $this->middleware('permission:Item Create', ['only' => ['create', 'store']]);
            $this->middleware('permission:Item List', ['only' => ['index','show']]);
            $this->middleware('permission:Item Edit', ['only' => ['update', 'edit']]);
            Fun::lang();
        }

        public function index(Request $request)
        {
            if ($request->ajax()) {
                $data = ProductModel::with('product_units')->latest()
                    ->take(20);
                $count = $data->count();
                return DataTables::of($data)
                    ->with([
                        "recordsTotal" => $count,
                        "recordsFiltered" => $count,
                    ])
                    ->addColumn('action', function ($action) {
                        $btn = '';
                        if (uCan('Item Edit')) {
                            $btn .= '<a href = "' . route("product.edit", $action->id) . '" class="fa fa-pencil btn btn-warning" title="' . __('administrator.edit') . '"></a>';
                        }
                        if (uCan('Item List')) {
                            $btn .= ' <a data-width="800px" data-href = "' . route("product.show", $action->id) . '" class="fa fa-eye btn btn-info getHtmlFormShow" title="' . __('administrator.show') . '"></a>';
                        }
                        return $btn;
                    })
                    ->editColumn('image', function ($action) {
                        if($action->image)
                        return '<img src="'.findImg($action->image).'" style="height:60px">';
                    })
                    ->editColumn('created_at', function ($action) {
                        return Carbon::parse($action->created_at)->format('d-m-Y');
                    })
                    ->editColumn('category_id', function ($action) {
                        return $action->category->category_name ?? '';
                    })
                    ->editColumn('brand_id', function ($action) {
                        return $action->brand->brand ?? '';
                    })


                    ->addIndexColumn()
                    ->rawColumns(['action', 'cost','image'])
                    ->make(true);

            }
            return view('administrator.item-setup.products.index');
        }

        public function create()
        {
            return view('administrator.item-setup.products.create');
        }
        public function store(Request $request)
        {
            return $this->update($request, null);
        }
        public function edit($id)
        {
            $master = ProductModel::find($id);
            $product_unit = ProductUnitModel::where('product_id', $id)->get();
            return view('administrator.item-setup.products.edit', compact('master', 'product_unit'));
        }
        public function show($id)
        {
            $master = ProductModel::find($id);
            return view('administrator.item-setup.products.show', compact('master'));
        }
        public function update(Request $request, $id)
        {
            $this->validate($request, [
                'product_name' => 'required|min:1|max:25|string|unique:nso007_products,product_name,' . $id,
                'item_code' => 'required|min:1|max:50|string|unique:nso007_products,item_code,' . $id,
                'category_id' => 'required|exists:nso007_category,id',
                'brand_id' => 'required|exists:nso007_product_brand,id',

                'unit_id' => 'required',
                'unit_id.*' => 'required',
                'code.*' => 'required',
                'barcode.*' => 'required',
                'qty.*' => 'required',
                'cost.*' => 'required',
                'price.*' => 'required',
            ]);
            $code = $request['code'];
            $barcode = $request['barcode'];
            $product_unit_id = $request['product_unit_id'];
            $cost = $request['cost'];
            $price = $request['price'];
            $unit_id = $request['unit_id'];
            $arr_product = $request->all();
            $arr_product['currency'] = 2;
            if ($request['image']) {
                $original_name = 'P'.Auth::user()->id.date('ymdhis').'.png';
                $destinationPath = 'images/product';
                $request['image']->move($destinationPath, $original_name);
                $image = $destinationPath . '/' . $original_name;
                $arr_product['image'] = $image;
            }
            $product = ProductModel::updateOrCreate([
                'id' => $id
            ], $arr_product);

            createProductAccountChart($product);
            foreach ($product_unit_id as $key => $item) {
                $check = ProductUnitModel::where('item_code',$code[$key])->first();
                if(!$check){
                    ProductUnitModel::updateOrCreate([
                        'id' => $item
                    ], [
                        'product_id' => $product->id,
                        'unit_id' => $unit_id[$key],
                        'cost' => $cost[$key],
                        'retail_price' => $price[$key],
                        'qty_per_unit' => 1,
                        'barcode' => $barcode[$key],
                        'item_code' => $code[$key],
                    ]);
                }
            }
            return response()->json(['route'=>route('product.index'),'status'=>1]);
        }

        public function destroy($id)
        {
            ProductUnitModel::where('product_id', $id)->delete();
            ProductModel::where('id', $id)->delete();
            return response()->json(['status' => 'ok']);
        }

        public function search_product(Request $request)
        {
            $key = $request->term['term'];

            $product = ProductUnitModel::Join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                ->selectRaw('nso007_product_unit.id,CONCAT(nso007_products.product_name," | ",nso007_product_unit.item_code) as name')
                ->where(function ($q) use ($key) {
                    if ($key) {
                        $q->where('nso007_products.product_name', 'like', '%' . $key . '%');
                        $q->orwhere('nso007_product_unit.item_code', 'like', '%' . $key . '%');
                    }
                })
                ->limit(30)->pluck('name', 'id')->prepend('Please Select', '');
            $arr = [];

            foreach ($product as $key => $row) {
                $arr[] = ['id' => $key, 'text' => $row];
            }
            return \Response::json($arr);

        }

        public function get_item_code_shelf(Request $request)
        {
            $cost = 0;
            $default_shelf = '';
            if ($request->product_unit) {
                $pro_unit = ProductUnitModel::find($request->product_unit);
                $product = getProductById($pro_unit->product_id);
                $default_shelf = $product->shelf;
                if ($pro_unit) {
                    if(ifMember()){
                        $cost = $pro_unit->retail_price;
                    }else{
                        $cost = $pro_unit->cost;
                    }
                }
            }
            $stock = StockModel::where(['product_unit_id' => $request->product_unit,'branch_id'=>FindBranchID()])
                ->where(function ($q) {
                    if(ifMember()){
                        $q->where('member_id',Auth::id());
                    }else{
                        $q->where('branch_id',FindBranchID());
                    }
                })
                ->groupBy('shelf')
                ->pluck('shelf');
            $shelf = ShelfModel::whereIn('id', $stock)->pluck('name', 'id');
            return response()->json(['shelf' => $shelf, 'cost' => $cost,'default_shelf'=>$default_shelf]);
        }
    }

