<?php

    namespace App\Http\Controllers\Accounting;

    use App\Model\Accounting\AccountChartModel;
    use App\Model\Accounting\AccountTypeModel;
    use App\Model\Accounting\JournalModel;
    use App\BranchModel;
    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use DB;
    use Auth;
    use Illuminate\Support\Facades\Crypt;
    use Illuminate\Validation\ValidationException;

    class AccountingReportsController extends Controller
    {

        function __construct()
        {
//        $this->middleware('permission:Accounting-Report-Ledger', ['only' => ['get_ledger']]);
//        $this->middleware('permission:Accounting-Report-Trail-Balance', ['only' => ['trial_balance']]);
//        $this->middleware('permission:Accounting-Report-Balance-Sheet', ['only' => ['balance_sheet']]);
//        $this->middleware('permission:Accounting-Report-Income-Statement', ['only' => ['income_statement']]);
        }

        public function ledger(Request $request)
        {
            if ($request->ajax()) {
                $acc_type = $request['acc_type'];
                $loop = $request['loop'];
                $date = $request['date'];
                $acc_number = $request['account_number'];
                $number_order = $request['number_order'];
                $journal_total_amount = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart', 'nso007_account_chart.id', 'jn.journal_acccode')
                    ->where('journal_acccode', 'like', $acc_type . '%')
                    ->where(function ($query) {
                        $query->where('jn.branch_id', Auth::user()->branch_id);
                    })
                    ->where(function ($q) use ($date) {
                        if ($date) {
                            $q->where('journal_paydate', '<=', date('Y-m-d', strtotime($date)));
                        }
                    })
                    ->where(function ($q) use ($acc_number) {
                        if ($acc_number) {
                            $q->where('journal_acccode', 'like', '%'.$acc_number.'%');
                        }
                    })
                    ->selectRaw('SUM(journal_debit) as debit,SUM(journal_credit) as credit')
                    ->first();
                $journal = DB::table('nso007_journal as jn')
                    ->join('users', 'users.id', 'jn.journal_by')
                    ->join('nso007_account_chart', 'nso007_account_chart.id', 'jn.journal_acccode')
                    ->select('jn.*', 'users.name as user_name', 'nso007_account_chart.acc_name', 'nso007_account_chart.acctype')
                    ->where('journal_acccode', 'like', $acc_type . '%')
                    ->where(function ($query) {
                        $query->where('jn.branch_id', Auth::user()->branch_id);
                    })
                    ->where(function ($q) use ($date) {
                        if ($date) {
                            $q->where('journal_paydate', date('Y-m-d', strtotime($date)));
                        }
                    })
                    ->where(function ($q) use ($acc_number) {
                        if ($acc_number) {
                            $q->where('journal_acccode', 'like', '%'.$acc_number.'%');
                        }
                    })
                    ->groupBy(['jn.id'])
                    ->orderBy('jn.journal_tran_id', 'DESC');
                $all_record = $journal->get()->count();
                if ($number_order == 'all') {
                    $journal = $journal->get();
                } else {
                    $journal = $journal->paginate($number_order);
                }
                return view('Accounting.reports.get-ledger-page-detail', compact('journal', 'acc_type', 'loop', 'all_record', 'journal_total_amount'));
            }
            return view('Accounting.reports.ledger');
        }

        public function trial_balance(Request $request)
        {
            if ($request->ajax()) {
                $from = $request['from_date'];
                $to = $request['to_date'];

                $net_income = [4 => 'jn.journal_credit-jn.journal_debit', 51 => 'jn.journal_debit-jn.journal_credit', 53 => 'jn.journal_debit-jn.journal_credit'];
                $total_net_income = 0;
                $balance_sheet = $request['balance_sheet'];
                foreach ($net_income as $acc_type => $operation) {
                    $net_in = DB::table('nso007_journal as jn')
                        ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                        ->select('chart.id', 'chart.acc_name', DB::raw('SUM(' . $operation . ') AS balance'))
                        ->where('chart.acctype', 'LIKE', $acc_type . "%")
                        ->where('jn.branch_id', FindBranchID())
                        ->whereIn('jn.journal_audit_status', $balance_sheet ? [1] : [0,1]) //$balance_sheet page balance sheet : else trail balance
                        ->where(function ($q) use ($from, $to) {
                            if ($from && $to) {
                                $q->whereBetween('jn.journal_paydate', [date('Y-m-d', strtotime($from)), date('Y-m-d', strtotime($to))]);
                            } else {
                                $q->whereBetween('jn.journal_paydate', [date('Y-m') . '-01', date('Y-m-d')]);
                            }
                        })
                        ->first();
                    if ($acc_type === 4) {
                        $total_net_income += $net_in->balance ?? 0;
                    } else {
                        $total_net_income -= $net_in->balance ?? 0;
                    }
                }

                $journal_acc = ["ASSETS" => 1, "LIABILITY" => 2, "EQUITY" => 3];
                foreach ($journal_acc as $k => $number) {
                    $journal_acc[$k] = DB::table('nso007_account_chart as chart')
                        ->join('nso007_account_type as type', 'type.id', 'chart.acctype')
                        ->select('chart.id', 'chart.acc_name')
                        ->where('type.id', 'LIKE', $number . '%')
                        ->get();
                }

                return view('Accounting.reports.get-trial-balance', compact('journal_acc', 'to', 'from', 'total_net_income', 'balance_sheet'));
            }
            return view('Accounting.reports.trial-balance');
        }


        public function balance_sheet()
        {
            return view('Accounting.reports.balance-sheet');
        }

        public function get_balance_sheet(Request $request)
        {

            $from = empty($request->from) ? '' : date('Y-m-d', strtotime($request->from));
            $to = empty($request->to) ? '' : date('Y-m-d', strtotime($request->to));
            $table = '';
            $total_asset = 0;
            $total_liability = 0;
            $total_equity = 0;
            $branch_id = $request->branch_id;
            $assets = DB::table('nso007_account_chart as chart')
                ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
                ->select('chart.id', 'chart.acc_name')
                ->where('type.id', 'LIKE', '1%')
                ->get();
            $liabilities = DB::table('nso007_account_chart as chart')
                ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
                ->select('chart.id', 'chart.acc_name')
                ->where('type.id', 'LIKE', '2%')
                ->get();

            $equities = DB::table('nso007_account_chart as chart')
                ->join('nso007_account_type as type', 'type.id', '=', 'chart.acctype')
                ->select('chart.id', 'chart.acc_name')
                ->where('type.id', 'LIKE', '3%')
                ->get();
            $table .= '<tr>
                        <td class="main mainac"><p>Assets</p></td>
                        <td class="main mainac1 line1" align="right"><p>' . date('d-m-Y') . '</p></td>
                     </tr>
                     ';
            foreach ($assets as $key => $asset) {
                $each_asset = 0;
                $account_assets = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                    ->select('chart.acctype', 'chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                    ->where('chart.acctype', 'like', substr($asset->id, 0, 2) . '%')
                    ->when(request('from', ''), function ($query) use ($from, $to) {
                        $query->whereBetween('jn.journal_paydate', [$from, $to]);
                    })
                    ->where(function ($query) use ($branch_id) {
                        if (myBranch()->main !== 1) {
                            $query->where('jn.branch_id', FindBranchID());
                        } else {
                            if (!empty($branch_id)) {
                                $query->where('jn.branch_id', $branch_id);
                            } else {
                                $query->where('jn.branch_id', Auth::user()->branch_id);
                            }
                        }
                    })
                    ->where('jn.journal_audit_status', 1)
                    ->groupBy('jn.journal_acccode')
                    ->get();

                if (!empty($account_assets[0])) {
                    $table .= '<tr>
                                <td class="main" ><p class="bold">' . $asset->acc_name . '</p></td>
                                <td></td>
                            </tr>';

                }

                $total_inventory = 0;
                foreach ($account_assets as $index => $account) {

                    $balance = $account->balance;
                    $each_asset += $balance;
                    $amount = $balance;
                    if ($account->acctype === 11006) {
                        $total_inventory += $amount;
                    }
                }
                if ($total_inventory) {
                    $table .= '<tr>
                                <td class="clickable-row sub" data-href="' . route('accounting-report.ledger', [Crypt::encrypt(11006), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <p class="num6018">11006 Total Inventory</p></td>
                                <td align="right"><p class="num18">$ ' . number_format($total_inventory, 2) . '</p></td>
                             </tr>
                             ';
                }
                if ($each_asset > 0) {
                    $table .= '<tr>
                                <td class="sub"><p class="bold">Total ' . $asset->acc_name . '</p></td>
                                <td align="right"><p class="line">$ ' . number_format($each_asset, 2) . '</p></td>
                             </tr>';

                }

                $total_asset += $each_asset;
            }
            $table .= '<tr>
                        <td class="main mainac" ><p>Total Assset</p></td>
                        <td align="right"><p class="boldline">$ ' . number_format($total_asset, 2) . '</p></td>
                     </tr>';

            //liabilities
            $table .= '<tr>
                         <td class="main mainac" ><p>Liabilities & Equity</p></td>
                         <td></td>
                     </tr>';

            $table .= '<tr>
                         <td class="main" ><p class="bold">Liabilities</p></td>
                         <td></td>
                     </tr>';
            foreach ($liabilities as $key => $liability) {
                $each_liability = 0;

                $account_liability = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                    ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                    ->where('chart.acctype', $liability->id)
                    ->when(request('from', ''), function ($query) use ($from, $to) {
                        $query->whereBetween('jn.journal_paydate', [$from, $to]);
                    })
                    ->where(function ($query) use ($branch_id) {
                        if (myBranch()->main !== 1) {
                            $query->where('jn.branch_id', FindBranchID());
                        } else {
                            if (!empty($branch_id)) {
                                $query->where('jn.branch_id', $branch_id);
                            } else {
                                $query->where('jn.branch_id', Auth::user()->branch_id);
                            }
                        }
                    })
//                ->whereBetween('jn.journal_paydate', [$from, $to])
                    ->where('jn.journal_audit_status', 1)
                    ->groupBy('jn.journal_acccode')
                    ->get();

                if (!empty($account_liability[0])) {
                    $table .= '<tr>
                                 <td class="sub_1" ><p class="num1840">' . $liability->acc_name . '</p></td>
                                 <td></td>
                             </tr>';

                }


                foreach ($account_liability as $account) {

                    $balance = $account->balance;
                    $each_liability += $balance;
                    $amount = $balance;
//                if ($amount > 0) {
//                    $amount = "(" . $amount . ")";
//                } else {
//                    $amount = abs($amount);
//                }
                    $table .= '<tr>
                                <td class="clickable-row sub" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($account->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <p class="num6018">' . $account->id . ' - ' . $account->acc_name . '</p>
                                </td>
                                <td align="right"><p class="num18">$ ' . number_format($amount, 2) . '</p></td>
                             </tr>';


                }
                $set_liability = $each_liability;

//            if ($set_liability > 0) {
//                $set_liability = "(" . $set_liability . ")";
//            } else {
//                $set_liability = abs($set_liability);
//            }
                if ($set_liability > 0) {
                    $table .= '<tr>
                                <td class="sub_total" ><p class="num1840">Total ' . $liability->acc_name . '</p></td>
                                <td align="right"><p class="line">$ ' . number_format($set_liability, 2) . '</p></td>
                             </tr>';


                }

                $total_liability += $each_liability;
            }
            $liability_balance = $total_liability;
//        if ($liability_balance > 0) {
//            $liability_balance = "(" . $liability_balance . ")";
//        } else {
//            $liability_balance = abs($liability_balance);
//        }
            if ($liability_balance > 0) {
                $table .= '<tr>
                            <td class="main" ><p class="bold">Total Liability</p></td>
                            <td align="right"><p class="num18">$ ' . number_format($liability_balance, 2) . '</p></td>
                         </tr>';

            }

            //liabilities


            //net_income
            //income
            $income = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select(DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                ->where('chart.acctype', 'LIKE', '4%')
                ->when(request('from', ''), function ($query) use ($from, $to) {
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->where(function ($query) use ($branch_id) {
                    if (myBranch()->main !== 1) {
                        $query->where('jn.branch_id', FindBranchID());
                    } else {
                        if (!empty($branch_id)) {
                            $query->where('jn.branch_id', $branch_id);
                        } else {
                            $query->where('jn.branch_id', Auth::user()->branch_id);
                        }
                    }
                })
                ->where('jn.journal_audit_status', 1)

                //            ->whereBetween('jn.journal_paydate', [$from, $to])
                ->first();
            //income
            //expense
            $expense = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select(DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                ->where('chart.acctype', 'LIKE', '5%')
                ->when(request('from', ''), function ($query) use ($from, $to) {
                    $query->whereBetween('jn.journal_paydate', [$from, $to]);
                })
                ->where(function ($query) use ($branch_id) {
                    if (myBranch()->main !== 1) {
                        $query->where('jn.branch_id', FindBranchID());
                    } else {
                        if (!empty($branch_id)) {
                            $query->where('jn.branch_id', $branch_id);
                        } else {
                            $query->where('jn.branch_id', Auth::user()->branch_id);
                        }
                    }
                })
                ->where('jn.journal_audit_status', 1)

                //            ->whereBetween('jn.journal_paydate', [$from, $to])
                ->first();
            //expense

            $net_income = abs($income->balance) - abs($expense->balance);

            //equity
            foreach ($equities as $equity) {


                $account_equity = DB::table('nso007_journal as jn')
                    ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                    ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                    ->where('chart.acctype', $equity->id)
                    ->when(request('from', ''), function ($query) use ($from, $to) {
                        $query->whereBetween('jn.journal_paydate', [$from, $to]);
                    })
                    ->where(function ($query) use ($branch_id) {
                        if (myBranch()->main !== 1) {
                            $query->where('jn.branch_id', FindBranchID());
                        } else {
                            if (!empty($branch_id)) {
                                $query->where('jn.branch_id', $branch_id);
                            } else {
                                $query->where('jn.branch_id', Auth::user()->branch_id);
                            }
                        }
                    })
//                ->whereBetween('jn.journal_paydate', [$from, $to])
                    ->where('jn.journal_audit_status', 1)
                    ->groupBy('jn.journal_acccode')
                    ->get();
                $table .= '<tr>
                                <td class="main" ><p class="bold">' . $equity->acc_name . '</p></td>
                                <td></td>
                             </tr>';


                foreach ($account_equity as $account) {

                    $balance = $account->balance;
                    $total_equity += $balance;
                    $amount = $balance;
//                if ($amount > 0) {
//                    $amount = "(" . $amount . ")";
//                } else {
//                    $amount = abs($amount);
//                }
                    $table .= '<tr>
                                <td class="sub" ><p class="num6018">' . $account->id . ' - ' . $account->acc_name . '</p></td>
                                <td align="right"><p class="num18">$ ' . number_format($amount, 2) . '</p></td>
                             </tr>';


                }
            }


            $table .= '<tr>
                            <td class="clickable-row sub" data-href="' . route('accounting-report.income-statement') . '">
                                <p class="num6018">31004 - Retained Earnings-current period</p>
                            </td>
                            <td align="right"><p class="num18">$ ' . number_format($net_income, 2) . '</p></td>
                         </tr>';


            //net_income
            $total_equity = abs($total_equity) + $net_income;
            $total_liability_and_equity = abs($total_liability) + $total_equity;

            $table .= '<tr>
                        <td class="clickable-row sub" data-href="' . route('accounting-report.income-statement') . '">
                            <p class="bold">Total Equities</p>
                        </td>
                        <td align="right"><p class="line">$ ' . number_format($total_equity, 2) . '</p></td>
                     </tr>';

            $table .= '<tr>
                        <td class="mainac clickable-row main" data-href="' . route('accounting-report.income-statement') . '">
                            <p>Total Liability and Equities</p>
                        </td>
                        <td align="right"><p class="boldline">$ ' . number_format($total_liability_and_equity, 2) . '</p></td>
                     </tr>';


            return $table;
        }

        public function income_statement(Request $request)
        {
            $branch = BranchModel::pluck('name', 'id')
                ->prepend('Please Select', '');
            return view('Accounting.reports.income-statement', compact('branch'));
        }

        public function get_income_statement(Request $request)
        {
            $from = $request['from_date'] ? date('Y-m-d', strtotime($request['from_date'])) : date('Y-m-d', strtotime('first day of this month'));
            $to = $request['to_date'] ? date('Y-m-d', strtotime($request['to_date'])) : date('Y-m-d', strtotime('last day of this month'));
            $table_income = '';
            $table_expense = '';
            $branch_id = $request->branch_id;
            $journal_income = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'chart.acc_name', DB::raw('SUM(jn.journal_credit-jn.journal_debit) AS balance'))
                ->where('chart.acctype', 'LIKE', "4%")
                ->where(function ($query) use ($branch_id) {
                    if (myBranch()->main !== 1) {
                        $query->where('jn.branch_id', FindBranchID());
                    } else {
                        if (!empty($branch_id)) {
                            $query->where('jn.branch_id', $branch_id);
                        } else {
                            $query->where('jn.branch_id', Auth::user()->branch_id);
                        }
                    }
                })
                ->whereBetween('jn.journal_paydate', [$from, $to])
                ->groupBy('chart.id')->get();
            $jn_income = [];
            $journal_expense_cog = DB::table('nso007_journal as jn')
                ->leftjoin('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->select('chart.id', 'jn.acctype', 'chart.acc_name', DB::raw('SUM(jn.journal_debit-jn.journal_credit) AS balance'))
                ->where('chart.acctype', 'LIKE', "51%")
                ->where(function ($query) use ($branch_id) {
                    if (myBranch()->main !== 1) {
                        $query->where('jn.branch_id', FindBranchID());
                    } else {
                        if (!empty($branch_id)) {
                            $query->where('jn.branch_id', $branch_id);
                        } else {
                            $query->where('jn.branch_id', Auth::user()->branch_id);
                        }
                    }
                })
                ->whereBetween('jn.journal_paydate', [$from, $to])
                ->groupBy('chart.id')
                ->get();
            $journal_expense_op = DB::table('nso007_journal as jn')
                ->join('nso007_account_chart as chart', 'chart.id', '=', 'jn.journal_acccode')
                ->selectRaw('chart.id,chart.acc_name,SUM(jn.journal_debit-jn.journal_credit) AS balance,chart.acctype')
                ->where('chart.acctype', 'LIKE', "53%")
                ->where(function ($query) use ($branch_id) {
                    if (myBranch()->main !== 1) {
                        $query->where('jn.branch_id', FindBranchID());
                    } else {
                        if (!empty($branch_id)) {
                            $query->where('jn.branch_id', $branch_id);
                        } else {
                            $query->where('jn.branch_id', Auth::user()->branch_id);
                        }
                    }
                })
                ->whereBetween('jn.journal_paydate', [$from, $to])
                ->groupBy('chart.acctype')
                ->get();
            if ($request['print']) {
                return view('Accounting.reports.report-print-income-statement', compact('journal_income', 'journal_expense_cog', 'journal_expense_op', 'from', 'to'));
            }
            $index = 0;
            $income = 0;
            $expense_op = 0;
            $expense_cog = 0;
            if (count($journal_income) > 0) {
                $table_income .= '<tr>
                                <th colspan="4"><span style="margin-left: 25px">I.Income</span></th>
                            </tr>';
                foreach ($journal_income as $key => $ji) {
                    $income += $ji->balance;
                    $index++;
                    if ($ji->balance < 0) {
                        $ji->balance = "(" . abs($ji->balance) . ")";
                    }
                    $table_income .= '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($ji->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td class="text-center">' . $index . '</td>
                                    <td>' . $ji->acc_name . '</td>
                                    <td>' . $ji->id . '</td>
                                    <td style="text-align: left">' . $ji->balance . '</td>
                                </tr>';
                    array_push($jn_income, $ji);
                }
            }
            if ($income < 0) {
                $income = "(" . abs($income) . ")";
            }
            if (count($jn_income) > 0) {
                $table_income .= '<tr class="total-section">
                                <th colspan="3"><span style="margin-left: 25px">Total Income</span></th>
                                <th>' . $income . '</th>
                            </tr>';
            }
            $table_expense .= '<tr class="total-section">
                                <th colspan="4"><span style="margin-left: 25px">II.Expense</span></th>
                            </tr>';
            if (count($journal_expense_cog) > 0) {
                $table_expense .= '<tr class="total-section">
                                <th colspan="4"><span style="margin-left: 50px">1.Cost of Goods Sold</span></th>
                            </tr>';
                foreach ($journal_expense_cog as $key => $je) {
                    $index++;
                    $expense_cog += $je->balance;
                    $table_expense .= '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($je->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                            <td class="text-center">' . $index . '</td>
                                            <td>' . $je->acc_name . '</td>
                                            <td>' . $je->id . '</td>
                                            <td style="text-align: left">' . $je->balance . '</td>
                                        </tr>';
                }

                $table_expense .= '<tr class="total-section">
                                <th colspan="3"><span style="margin-left: 25px">Total Cost of Goods Sold</span></th>
        <th>' . $expense_cog . '</th>
                            </tr>';
            }
            if (count($journal_expense_op) > 0) {
                $table_expense .= '<tr class="total-section">
                                <th colspan="4"><span style="margin-left: 50px">2.Operation Expense</span></th>
                            </tr>';
                foreach ($journal_expense_op as $key => $je) {
                    $index++;
                    $expense_op += $je->balance;
                    $table_expense .= '<tr class="clickable-row" data-href="' . route('accounting-report.ledger', [Crypt::encrypt($je->id), Crypt::encrypt($from), Crypt::encrypt($to)]) . '">
                                    <td class="text-center">' . $index . '</td>
                                    <td>Marketing Expense (Saving Point)<i class="display-none">' . $je->acc_name . '</i></td>
                                    <td>' . $je->id . '</td>
                                    <td style="text-align: left">' . $je->balance . '</td>
                                </tr>';
                }
                $table_expense .= '<tr class="total-section">
                                <th colspan="3"><span style="margin-left: 25px">Total Operation Expense</span></th>


        <th>' . $expense_op . '</th>
                            </tr>';
            }
            $expense = $expense_op + $expense_cog;
            $table_expense .= '<tr class="total-section"><th colspan="3">TOTAL EXPENSE: (1)+(2)</th><th>' . ($expense) . '</th></tr>';
            $net_income = abs($income) - abs($expense);
            $row_profit_loss = '';
            if (!empty($net_income)) {
                if ($net_income < 0) {
                    $net_income = "(" . abs($net_income) . ")";
                }
                $row_profit_loss .= '<tr class="total-section">
                                <th colspan="3">NET INCOME: (I) - (II)</th>
                                <th>' . $net_income . '</th>
                            </tr>';
            }
            $table = $table_income . $table_expense . $row_profit_loss;
            if ($table == "") {
                $table .= '<tr align="center"><td colspan="4">' . __('administrator.no_data') . '</td></tr>';
            }
            return $table;
        }

        public function run_trial_balance(Request $request)
        {
            $this->validate($request, [
                'from_date' => 'required',
                'to_date' => 'required',
            ]);
            $from = date('Y-m-d', strtotime($request['from_date']));
            $to = date('Y-m-d', strtotime($request['to_date']));
            if ($request['to_date'] && $request['from_date']) {
                JournalModel::
                where('journal_audit_status', 0)
                    ->where(function ($query) use ($from, $to) {
                        $query->whereBetween('journal_paydate', [$from, $to]);
                    })
                    ->where('journal_audit_status', '!=', 1)
                    ->update(['journal_audit_status' => 1]);
                return response()->json(['status' => 'success', 'reload' => 1]);
            }
            throw ValidationException::withMessages(['field_name' => 'Date is incorrect!!']);
        }

        public function previousDate($date)
        {
            return date('Y-m-d', strtotime("$date -1 month"));
        }
    }
