<?php

    namespace App\Http\Controllers\Accounting;

    use App\Model\Accounting\AccountTypeModel;
    use App\Model\Accounting\AccountChartModel;
    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use DataTables;
    use DB;
    use Auth;

    class AccountChartController extends Controller
    {
//    function __construct()
//    {
//        $this->middleware('permission:Account-Chart-List');
//        $this->middleware('permission:Account-Chart-Create', ['only' => ['create','store']]);
//        $this->middleware('permission:Account-Chart-Edit', ['only' => ['edit','update']]);
//        $this->middleware('permission:Account-Chart-Delete', ['only' => ['confirm_delete']]);
//    }
        public function index()
        {
            $account_chart = AccountChartModel::leftjoin('nso007_account_type', "nso007_account_type.id", "nso007_account_chart.acctype")
                ->select("nso007_account_chart.*", "nso007_account_type.acctype_name")
                ->where('nso007_account_chart.default', 1)
                ->where('nso007_account_chart.sub_acc', 0)
                ->orderBy('nso007_account_chart.id', 'ASC')
                ->get();
            return view('Accounting.account-chart.index', compact('account_chart'));
        }

        public function create()
        {
            $account_type = AccountTypeModel::select(
                DB::raw('CONCAT(id," ",acctype_name) AS account_mixed'), 'id')
                ->pluck('account_mixed', 'id')
                ->prepend('Please Select', '');
            return view('Accounting.account-chart.create', compact('account_type'));
        }

        public function store(Request $request)
        {
            $this->validate($request, [
                'account_type' => 'required|exists:nso007_account_type,id',
                'main_account' => 'required|exists:nso007_account_chart,id',
                'sub_account' => 'exists:nso007_account_chart,id',
                'acc_num' => 'required',
                'acc_name_kh' => 'required',
                'acc_name_en' => 'required',
            ]);
            if ($request['check'] === 'sub') {
                $sub_acc = 1;
                $acc_type = $request['sub_account'];
            } else {
                $sub_acc = 0;
                $acc_type = $request['main_account'];
            }
            $data = array(
                'id' => $request['acc_num'],
                'branch_id' => FindBranchID(),
                'user_id' => Auth::user()->id,
                'acc_name' => $request['acc_name_en'],
                'acc_namekh' => $request['acc_name_kh'],
                'acctype' => $acc_type,
                'acc_des' => $request['acc_des'],
                'acc_delete' => 1,
                'acc_status' => 1,
                'sub_acc' => $sub_acc,
            );
            AccountChartModel::create($data);
            return response()->json(['status' => 'success', 'route' => route('account-chart.index')]);
        }

        public function get_account_code(Request $request)
        {
            $account_type = $request['account_type'];
            $main_account = $request['main_account'];
            $sub_account = $request['sub_account'];
            $no_branch = $request['no_branch'];
            $number = 0;
            if (!$main_account) {
                $sub_acc_of = null;
                $account_chart = AccountChartModel::where('acctype', $account_type)->pluck('acc_name', 'id');
            } else {
                $account_chart = null;
                $sub_acc_of = AccountChartModel::where('acctype', $main_account)
                    ->where(function ($q) use ($no_branch) {
                        if (!$no_branch) {
                            $q->where('branch_id', FindBranchID());
                        }
                    })
                    ->pluck('acc_name', 'id');
                if ($sub_account) {
                    $count = AccountChartModel::where('acctype', $sub_account)->count();
                    $count += 1;
                    $number = $sub_account . $count;
                } else {
                    $count = AccountChartModel::where('acctype', $main_account)->count();
                    $count += 1;
                    $number = $main_account . $count;
                }
            }
            $data = array('main_account' => $account_chart, 'sub_account' => $sub_acc_of, 'number' => $number);
            return response()->json($data);
        }

        public function edit($id)
        {
            $account_type = AccountTypeModel::select(
                DB::raw('CONCAT(id," ",acctype_name) AS account_mixed'), 'id')
                ->pluck('account_mixed', 'id')
                ->prepend('Please Select', '');
            $account_chart = AccountChartModel::findOrFail($id);
            $acc_type_name = null;
            $sub_acc = null;
            $acc_type = null;
            $sub_acc_type = null;
            if ($account_chart->sub_acc != 0) {
                $sub_acc = AccountChartModel::where('id', $account_chart->acctype)->first();
                $sub_acc_type = AccountChartModel::where('id', $sub_acc->acctype)->first();
                $acc_type_name = $sub_acc_type != null ? $sub_acc_type->id . ' ' . $sub_acc_type->acc_name : null;
                $acc_type = optional($sub_acc_type->account_type)->acctype_name;
            } else {
                $sub_acc_type = AccountChartModel::where('id', $account_chart->acctype)->first();
                $acc_type_name = $sub_acc_type != null ? $sub_acc_type->id . ' ' . $sub_acc_type->acc_name : null;
                $acc_type = optional($sub_acc_type->account_type)->acctype_name;
            }

            $sub_acc_of = $sub_acc != null ? $sub_acc->id . ' | ' . $sub_acc->acc_name : null;
            return view('Accounting.account-chart.edit', compact('account_chart', 'account_type', 'acc_type_name', 'sub_acc_of', 'sub_acc', 'acc_type', 'sub_acc_type'));
        }

        public function confirm_delete(Request $request)
        {
            $delete_acc = AccountChartModel::findOrFail($request->delete_id);
        $delete_acc->delete();
            return redirect()->route('account-chart.index')->with('success', 'Account chart deleted');
        }

        public function update(Request $request, $id)
        {
            $account = AccountChartModel::findOrFail($id);
            $account->acc_name = $request->acc_name;
            $account->acc_namekh = $request->acc_namekh;
            $account->acc_des = $request->acc_des;
            $account->save();
            return redirect()->route('account-chart.index')
                ->with('success', 'Account Chart updated successfully');
        }

        public function search_acc_chart(Request $request)
        {
            $key = $request->term['term'];
            $product = AccountChartModel::
            selectRaw('CONCAT(id," | ",acc_name) as name,id')
                ->where(function ($q) use ($key) {
                    if ($key) {
                        $q->where('id', 'like', $key . '%');
                        $q->orWhere('acc_name', 'like','%'.$key . '%');
                    }
                })
                ->where(function ($q) use ($key) {
                    $q->where('branch_id', FindBranchID());
                    $q->orwhere('branch_id', 0);

                })
                ->where('nso007_account_chart.acc_name', 'not like', 'Account Receivable%')
                ->where('nso007_account_chart.acc_name', 'not like', 'Account Payable%')
                ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point liability - %')
                ->where('nso007_account_chart.acc_name', 'not like', 'Saving Point Expense - %')
                ->limit(60)->pluck('name', 'id')->prepend('Please Select', '');
            $arr = [];

            foreach ($product as $key => $row) {
                $arr[] = ['id' => $key, 'text' => $row];
            }
            return \Response::json($arr);

        }
    }
