<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Model\Promotion;
use App\Model\ProductUnitModel;

class CronjobPromotion extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'run:promotion';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update promotion';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        ProductUnitModel::query()->update(['discount' => 0]);
        $promotion = Promotion::join('promotion_details', 'promotion_details.promotion_id', 'promotions.id')
                                // ->join('nso007_product_unit', 'promotion_details.product_id', 'nso007_product_unit.id')
                                // ->join('nso007_products', 'nso007_product_unit.product_id', 'nso007_products.id')
                                ->where('promotions.type', 'Product Promotion')
                                ->whereNull('promotions.deleted_at')
                                ->whereDate('start_date',  '<=', date("Y-m-d"))
                                ->whereDate('end_date',  '>=', date("Y-m-d"))
                                ->selectRaw('branch, start_date, end_date, product_id, discount')
                                ->get();
        if(!$promotion->isEmpty()){
            foreach($promotion as $item){
                ProductUnitModel::find($item->product_id)->update(['discount' => $item->discount]);
            }
        }
    }
}
