<?php $__env->startSection("content"); ?>
<?php echo $__env->make("commission.form-withdraw-commission", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1><?php echo e(__("application.List")); ?> <?php echo e(__("application.Commission")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.POS Operation")); ?></li>
              <li class="breadcrumb-item active"><?php echo e(__("application.List")); ?> <?php echo e(__("application.Commission")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-commission" class="table table-bordered table-hover text-nowrap">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Date")); ?></th>
                  <th><?php echo e(__("application.Client")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Agency")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Project")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Item")); ?> <?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Amount")); ?> <?php echo e(__("application.Commission")); ?> ($)</th>
                  <th><?php echo e(__("application.Amount")); ?> <?php echo e(__("application.Available")); ?>($)</th>
                  <th><?php echo e(__("application.Amount")); ?> <?php echo e(__("application.Withdraw")); ?>($)</th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  function withdraw_form(obj){
    if($(obj).closest('tr').hasClass("child")){
      var id=$(obj).closest('tr').prev().attr('id');
    }else{
      var id=$(obj).closest('tr').attr('id');
    }
    $(".main-spinner").show();
    $.ajax({
      url:"<?php echo e(route('commission.get_commission_info')); ?>",
      dataType:"JSON",
      type:"POST",
      data:{
        "_token":"<?php echo e(csrf_token()); ?>",
        "commission_id":id
      },
      success:function(data){
        $(".main-spinner").hide();
        $("#form-withdraw-commission").modal("show");
        $("#commission-id").val(id);
        $("#commission-amount").val(data.commission_amount);
        $("#amount-available").val(data.amount_available);
        $("#withdraw-amount").val(data.amount_available);
      },
      error:function(){
        toastr.error("Error with your request. Please try again !");
      }
    });
  }
  function save_withdraw_commission(){
    var commission_id = $("#commission-id").val();
    var commission_amount = $("#commission-amount").val();
    var amount_available = Number($("#amount-available").val());
    var amount_withdraw = Number($("#withdraw-amount").val());
    var description = $("desciption").val();
    var date = $("#date-pay").val();
    if(commission_id==""||date==""){
      toastr.error("Error your request. Please try again !");
    }
    else if(amount_withdraw>amount_available||amount_withdraw<=0||amount_withdraw==""){
      toastr.warning("Please check withdraw amount again");
    }else{
      $("#form-withdraw-commission").modal("hide");
      $(".main-spinner").show();
      $.ajax({
        url:"<?php echo e(route('commission.save_withdraw_commission')); ?>",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"<?php echo e(csrf_token()); ?>",
          "commission_id":commission_id,
          "withdraw_amount":amount_withdraw,
          "description":description,
          "date":date
        },
        success:function(data){
          if(data!="ERROR")
          {
            $(".main-spinner").hide();
            var amount_available = Number($("#amount-available-"+commission_id).text());
            $("#amount-available-"+commission_id).text(amount_available-Number(amount_withdraw));
            var amount_withdraw1 = Number($("#amount-withdraw-"+commission_id).text());
            $("span#amount-withdraw-"+commission_id).text(amount_withdraw1+Number(amount_withdraw));

            $("span#btn-view-commission-history-"+commission_id).empty();
            var append_data=`<a href='javascript:void(0)' onclick='view_history(${commission_id},this)' class='btn btn-sm btn-info' title='view withdraw history'><i class='fas fa-eye'></i></a>`;
            if(data.amount_available<=2){
              append_data+=` <button disabled class='btn btn-sm btn-success' title=' withdraw commission'><i class='fas fa-dollar-sign'></i></button>`;
            }else{
              append_data+=` <a href='javascript:void(0)' class='btn btn-sm btn-success' title=' withdraw commission' onclick='withdraw_form(this)'><i class='fas fa-dollar-sign'></i></a>`;
            };
            $("span#btn-view-commission-history-"+commission_id).append(append_data);
            $('#datable-commission').DataTable().draw(true);
            toastr.success("Your request is success !");
          }
          else
          {
            toastr.success("Your request is faile !");
          }
          
        },
        error:function(){
          toastr.error("Error with your request. Please try again !");
        }
      });
    }
  }
  function view_history(id,obj){
    var route = "<?php echo e(route('commission.get_commission_history')); ?>";
    var tr="";
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"post",
      dataType:"JSON",
      async:false,
      data:{
        "_token":"<?php echo e(csrf_token()); ?>",
        "commission_id":id
      },
      success:function(data){
        $(".main-spinner").hide();
        $.each(data,function(index,val){
          var des="";var route_print="";
          route_print="<?php echo e(route("commission.print_invoice_commission",":id")); ?>";
          route_print=route_print.replace(":id",val.id);
          console.log(val.id);
          if(val.description!=null) des = val.description;
          tr+=`
              <tr>
                <td style="text-align:center;">${index+1}</td>
                <td style="text-align:center;">${val.date}</td>
                <td style="text-align:center;">${val.amount}$</td>
                <td style="text-align:center;">${des}</td>
                <td style="text-align:center;">
                  <a href='${route_print}' target='_blank' class='btn btn-sm btn-primary' title='Print'>
                    <i class='fas fa-print'></i>
                  </a>
                </td>
              </tr>`;
        });
      }
    });
    var table_append=`<tr id="tb-commission-hostory-${id}">
                        <td colspan="10">
                         <table class="table table-bordered table-hover text-nowrap">
                            <thead>
                              <tr><th colspan="5" style="text-align:center;"><?php echo e(__("application.Commission​ Withdraw History")); ?></th></tr>
                              <tr>
                                <th style="text-align:center"><?php echo e(__("application.No")); ?></th>
                                <th style="text-align:center"><?php echo e(__("application.Date")); ?></th>
                                <th style="text-align:center"><?php echo e(__("application.Amount")); ?></th>
                                <th style="text-align:center"><?php echo e(__("application.Description")); ?></th>
                                <th style="text-align:center"><?php echo e(__("application.Action")); ?></th>
                              </tr>
                            </thead>
                            <tbody>
                              ${tr}
                            </tbody>
                         </table>
                        </td>
                      </tr>`;
    if($('tr#'+id).hasClass("parent")){
        $("tr#"+id).next().after(table_append);
    }else{
          $("tr#"+id).after(table_append);
      
    }
    var btn_close_view=`
            <a href='javascript:void(0)' onclick='close_view_history(${id},this)' class='btn btn-sm btn-warning' title='close view withdraw history'>
                <i class="far fa-eye-slash"></i>
            </a>
            `;
    $(obj).before(btn_close_view);
    $(obj).hide();
  }
  function close_view_history(id,obj){
    $("tr#tb-commission-hostory-"+id).remove();
    $(obj).next().show();
    $(obj).remove();
  }
  //For correct view commission history
  window.addEventListener("resize", resizeFunction);
  function resizeFunction() {
    window.location.reload();
  }
  //end

  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-commission').DataTable({  
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          ajax: "<?php echo e(route('commission.get_index')); ?>",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'date','name':'nso007_commission.date'},
              {data: 'client_name','name':'nso007_client.name'},
              {data: 'agency_name','name':'nso007_agency.name'}, 
              {data: 'project_name','name':'nso007_project_stock.name'},  
              {data: 'item_name','name':'nso007_item_stock.name'},  
              {data: 'commission_amount','name':'nso007_commission.commission_amount','searchable': false},  
              {data: 'amount_available','name':'nso007_commission.amount_available','searchable': false}, 
              {data: 'amount_withdraw','name':'nso007_commission.amount_withdraw','searchable': false}, 
              {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/commission/index.blade.php ENDPATH**/ ?>