<?php $__env->startSection("content"); ?>
<?php echo $__env->make('agencies.show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('agencies.confirm_active', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Agency List</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
              <li class="breadcrumb-item active">Manage Agency</li>
              <li class="breadcrumb-item active">Show</li>
              <li class="breadcrumb-item active">Agency Inactive</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-agency" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>No</th>
                  <th>Image</th>
                  <th>Name</th>
                  <th>Phone</th>
                  <th>ID Card</th>
                  <th>Address</th>
                  <th>Action</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  function set_active(id){
    $("#ag-id").val(id);
  }
  function processActive(){
    var id = $("#ag-id").val();
    $('.main-spinner').show();
    $.ajax({
      type:"POST",
      dataType:"JSON",
      url:"<?php echo e(route('agencies.set_to_active')); ?>",
      data:{
        "_token":"<?php echo e(csrf_token()); ?>",
        "id":id
      },
      success:function(data){
        $('.main-spinner').hide();
        window.location.reload();
        toastr.success("Agency change to active successfully !");
      }
    });
  }
  function show_info(id){
      var route="<?php echo e(route('agency.show',':id')); ?>";
      route=route.replace(":id",id);
      $('.main-spinner').show();
      $.ajax({
        url:route,
        type:"GET",
        dataType:"JSON",
        success:function(data){
          $('.main-spinner').hide();
          $("#ag-name").empty();
          $("#ag-name").append(data.name);
          if(data.name==null){
            $(".show-name").hide();
          }
          $("#ag-gender").empty();
          $("#ag-gender").append(data.gender);
          if(data.gender==null){
            $(".show-gender").hide();
          }
          $("#ag-phone").empty();
          $("#ag-phone").append(data.phone);
          if(data.phone==null){
            (".show-phone").hide();
          }
          $("#ag-dob").empty();
          $("#ag-dob").append(data.date_of_birth);
          if(data.date_of_birth==null){
            $(".show-des").hide();
          }
          $("#ag-nation").empty();
          $("#ag-nation").append(data.nationality);
          if(data.nationality==null){
            $(".show-nation").hide();
          }
          $("#ag-idcard").empty();
          $("#ag-idcard").append(data.id_card_number);
          if(data.id_card_number==null){
            $(".show-idcard").hide();
          }
          $("#ag-idcard-date-valid").empty();
          $("#ag-idcard-date-valid").append(data.id_card_date_valid);
          if(data.id_card_date_valid==null){
            $(".show-idcard-date-valid").hide();
          }
          $("#ag-mail").empty();
          $("#ag-mail").append(data.email);
          if(data.email==null){
            $(".show-email").hide();
          }
          $("#ag-address").empty();
          var address="";
          if(data.house_number!=null) address+=data.house_number;
          if(data.street_number!=null) address+=" "+data.street_number;
          if(data.get_village['village_km']!=null) address+="​ ភូមិ​​ "+data.get_village['village_km'];
          if(data.get_commune['commune_km']!=null) address+=",​ ឃុំ "+data.get_commune['commune_km'];
          if(data.get_district['district_km']!=null) address+=", ស្រុក"+data.get_district['district_km'];
          if(data.get_province['province_km']!=null) address+=", ខេត្ត"+data.get_province['province_km'];
          $("#ag-address").append(address);
          $("#ag-des").empty();
          $("#ag-des").append(data.description);
          if(data.description==null){
            $(".show-des").hide();
          }
          $("#ag-status").empty();
          $("#ag-status").append("<p class='text-danger'>Inactived</p>");
           var resource="";
          if(data.image!=''){
            var resource="assets/img/upload/"+data.image;
            document.getElementById("image-field").src=resource;
          }else{
             document.getElementById("image-field").src="assets/img/defaultphoto.png";
          }
          
        }
      });
    }
  $(document).ready(function() {
      $('.main-spinner').show();
      $('#datable-agency').DataTable({
          "autoWidth": false,
          ordering: false,
          serverSide: true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          ajax: "<?php echo e(route('datatable.datatable_get_agency_inactive')); ?>",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {"data": "image",
                "render": function(data, type, row) {
                  return '<img src="' + data + '" border="0" width="100px" height="80px" class="img-rounded" align="center" />';
                }
              }, 
              {data: 'name','name':'nso007_agency.name'}, 
              {data: 'phone','name':'nso007_agency.phone'}, 
              {data: 'id_card_number','name':'nso007_agency.id_card_number'}, 
              {data: 'address','name':'nso007_agency.address'}, 
              {data: 'action','searchable': false}, 
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
          }
      });

      $.fn.dataTable.ext.errMode = 'throw';
  });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "<?php echo e(route('user.update_status',':id')); ?>";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"<?php echo e(csrf_token()); ?>"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/agencies/index_inactive.blade.php ENDPATH**/ ?>