<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo e(__('administrator.info_detail')); ?> </h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <div class="row">
                    <div class="col-md-12">
                        <table class="table">
                            <tr>
                                <td><?php echo e(__('administrator.code')); ?></td>
                                <td><span class="code"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.job_title')); ?></td>
                                <td><span class="job_title"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.job_function')); ?></td>
                                <td><span class="job_function"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.department')); ?></td>
                                <td><span class="department"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.gender')); ?></td>
                                <td><span class="sex"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.age')); ?></td>
                                <td><span class="age"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.description')); ?></td>
                                <td><span class="job_description"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.education_level')); ?></td>
                                <td><span class="education_level"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.employment_type')); ?></td>
                                <td><span class="employment_type"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.year_of_exp')); ?></td>
                                <td><span class="exp_year"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.requirement')); ?></td>
                                <td><span class="requirement"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.benefit')); ?></td>
                                <td><span class="benefit"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.hiring')); ?></td>
                                <td><span class="hiring_amt"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.location')); ?></td>
                                <td><span class="location"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.closing_date')); ?></td>
                                <td><span class="closing_date"></span></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                class="fa fa-close"></i> <?php echo e(__('administrator.close')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.job_position')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.job_position')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Job Position Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-job-post.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.code')); ?></th>
                                        <th><?php echo e(__('administrator.job_title')); ?></th>
                                        <th><?php echo e(__('administrator.department')); ?></th>
                                        <th><?php echo e(__('administrator.employment_type')); ?></th>
                                        <th><?php echo e(__('administrator.location')); ?></th>
                                        <th><?php echo e(__('administrator.closing_date')); ?></th>
                                        <th><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).on('click', '.viewot', function () {
            var id = $(this).data('id');
            $('#viewModal').modal('show');
            $.ajax({
                url: "<?php echo e(route('hr.view-job-post')); ?>",
                type: 'GET',
                data: {
                    "id": id,
                },
                success: function (data) {
                    $('.code').text(data.datas.job_code);
                    $('.job_title').text(data.datas.job_title);
                    $('.job_description').text(data.datas.job_description);
                    $('.requirement').text(data.datas.requirement);
                    $('.department').text(data.datas.department);
                    $('.employment_type').text(data.datas.employment_type);
                    $('.exp_year').text(data.datas.exp_year);
                    $('.job_function').text(data.datas.job_function);
                    $('.education_level').text(data.datas.education_level);
                    $('.salary').html(data.datas.salary);
                    $('.hiring_amt').text(data.datas.hiring_amt);
                    $('.sex').text(data.datas.sex);
                    $('.age').html(data.datas.age);
                    $('.location').text(data.datas.location);
                    $('.closing_date').text(data.datas.closing_date);
                    $('.benefit').html(data.datas.benefit);

                    $('body :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/1/g, '<?php echo e(__('administrator.1')); ?>').replace(/2/g, '<?php echo e(__('administrator.2')); ?>').replace(/3/g, '<?php echo e(__('administrator.3')); ?>').replace(/4/g, '<?php echo e(__('administrator.4')); ?>').replace(/5/g, '<?php echo e(__('administrator.5')); ?>').replace(/6/g, '<?php echo e(__('administrator.6')); ?>').replace(/7/g, '<?php echo e(__('administrator.7')); ?>').replace(/8/g, '<?php echo e(__('administrator.8')); ?>').replace(/9/g, '<?php echo e(__('administrator.9')); ?>').replace(/0/g, '<?php echo e(__('administrator.0')); ?>');
                    });
                }
            });
        });
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-job-post')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', 'searchable': false},
                        {data: 'job_code'},
                        {data: 'job_title'},
                        {data: 'department'},
                        {data: 'employment_type'},
                        {data: 'location'},
                        {data: 'closing_date'},
                        {data: 'action', 'searchable': false},
                    ],
                "initComplete": function (settings, json) {

                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/job-post/index.blade.php ENDPATH**/ ?>