<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hr.employee-promote.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('hr.employee-promote.modal-show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.promotion")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.promotion")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.code')); ?></th>
                                        <th><?php echo e(__('administrator.english_name')); ?></th>
                                        <th><?php echo e(__('administrator.khmer_name')); ?></th>
                                        <th><?php echo e(__('administrator.branch')); ?></th>
                                        <th><?php echo e(__('administrator.department')); ?></th>
                                        <th><?php echo e(__('administrator.position')); ?></th>
                                        <th><?php echo e(__('administrator.increment_date')); ?></th>
                                        <th><?php echo e(__('administrator.basic_salary')); ?></th>
                                        <th><?php echo e(__('administrator.increment_salary')); ?></th>
                                        <th><?php echo e(__('administrator.reason')); ?></th>
                                        <th style="width: 200px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn-view', function(){
                var id = $(this).data('id');
                var route = "<?php echo e(route('hr.show-promote',':id')); ?>";
                route = route.replace(':id', id);
                $.ajax({
                    url: route,
                    type: 'GET',
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        id: id
                    },
                    success: function(data){
                        var old_date    = data.increment_date ? data.increment_date : "";
                        var arr         = old_date.split('-');
                        var new_date    = arr[2]+'-'+arr[1]+'-'+arr[0];

                        var branch          = data.get_branch != null ? data.get_branch.english_name : "";
                        var department      = data.get_department != null ? data.get_department.english_name : "";
                        var position        = data.get_position != null ? data.get_position.english_name : "";

                        $('#code').val(data.code);
                        $('#khmer_name').val(data.name_kh);
                        $('#english_name').val(data.name);
                        $('#branch').val(branch);
                        $('#department').val(department);
                        $('#position').val(position);
                        $('#increment_date').val(new_date);
                        $('#basic_salary').val(data.basic_salary);
                        $('#increment_salary').val(data.increment_salary);
                        $('#reason').val(data.reason);
                        $('#form-show').modal('show');
                    },
                    error: function(e){
                        console.log('error');
                    }
                });
            });
            $(document).on('click','.btn-delete-promote', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-emp-promote')); ?>",
                columns:
                    [
                        {
                            data: 'DT_RowIndex', 
                            searchable: false
                        },
                        {
                            data: 'code'
                        },
                        {
                            data: 'name_kh'
                        },
                        {
                            data: 'name'
                        },
                        {
                            data: 'branch_id'
                        },
                        {
                            data: 'department_id'
                        },
                        {
                            data: 'position_id'
                        },
                        {
                            data: 'increment_date'
                        },
                        {
                            data: 'basic_salary'
                        },
                        {
                            data: 'increment_salary'
                        },
                        {
                            data: 'reason'
                        },
                        {
                            data: 'action', 
                            searchable: false
                        },
                    ],
                "initComplete": function (settings, json) {
                }
            });
            
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/employee-promote/index.blade.php ENDPATH**/ ?>