<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo e(__('administrator.are_you_sure')); ?></h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <form role="form" method="POST" id="form_update">
                    <?php echo e(csrf_field()); ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-12">
                                <input type="hidden" name="id" id="id">
                            </div>
                            <div class="form-group col-sm-12 col-xs-12">
                                <label class="required"><?php echo e(__('administrator.status')); ?></label>
                                <select name="status" class="form-control input-lg" required>
                                    <option value=""><?php echo e(__('administrator.please_select')); ?></option>
                                    <option value="1"><?php echo e(__('administrator.activate')); ?>

                                    </option>
                                    <option value="0"><?php echo e(__('administrator.deactivate')); ?>

                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                    class="fa fa-close"></i> <?php echo e(__('administrator.close')); ?>

                        </button>
                        <button type="submit" class="btn btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> <?php echo e(__('administrator.save')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.employee")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.employee")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Employee Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-employee.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.photo')); ?></th>
                                        <th><?php echo e(__('administrator.khmer_name')); ?></th>
                                        <th><?php echo e(__('administrator.english_name')); ?></th>
                                        <th><?php echo e(__('administrator.code')); ?></th>
                                        <th><?php echo e(__('administrator.contact')); ?></th>
                                        <th><?php echo e(__('administrator.dob')); ?></th>
                                        <th><?php echo e(__('administrator.gender')); ?></th>
                                        <th><?php echo e(__('administrator.branch')); ?></th>
                                        <th><?php echo e(__('administrator.department')); ?></th>
                                        <th><?php echo e(__('administrator.position')); ?></th>
                                        <th><?php echo e(__('administrator.status')); ?></th>
                                        <th style="width: 200px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                $('#id').val(id);
                var url = "<?php echo e(route('hr.employee-change-status')); ?>";
                $('#form_update').attr('action', url);
                $('#myModal').modal('show');
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-employee')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false, orderable: false},
                        {
                            "data": "avatar",
                            "render": function (data, type, row) {
                                return '<center><img src="' + data + '" border="0" width="35" height="35" class="img-circle" align="center" /></center>';
                            }
                        },
                        {data: 'khmer_name'},
                        {data: 'english_name'},
                        {data: 'user_code'},
                        {data: 'user_phone'},
                        {data: 'user_dob'},
                        {data: 'user_gender'},
                        {data: 'branch_id'},
                        {data: 'department_id'},
                        {data: 'position_id'},
                        {data: 'status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/employee/index.blade.php ENDPATH**/ ?>