<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#"><?php echo e(__('administrator.workday')); ?></a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3><?php echo e(__('administrator.workday')); ?> </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="<?php echo e(route('hr-work-day.create')); ?>"
                               class="button_primary"><?php echo e(__('administrator.add_new')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('administrator.code')); ?></th>
                    <th><?php echo e(__('administrator.name')); ?></th>
                    <th><?php echo e(__('administrator.work')); ?></th>
                    <th><?php echo e(__('administrator.action')); ?></th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "<?php echo e(route('datatable.hr-get-workday')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'code'},
                        {data: 'name'},
                        {data: 'work'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                    $('#datatable_products tbody :not(script)').contents().filter(function () {
                        return this.nodeType === 3;
                    }).replaceWith(function () {
                        return this.nodeValue.replace(/full_day/g, '<?php echo e(__('administrator.full_day')); ?>').replace(/half_day/g, '<?php echo e(__('administrator.half_day')); ?>').replace(/day_off/g, '<?php echo e(__('administrator.day_off')); ?>');
                    });
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/work-day/index.blade.php ENDPATH**/ ?>