<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php
        
    ?>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><?php echo e(__('administrator.report_attendance')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12 form-group paddin-0">
                        <div>
                            <?php echo Form::open(array('route' => 'get-report-employee','method'=>'get')); ?>

                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <?php
                                            $user = App\User::pluck('name', 'id')->prepend(__('administrator.please_select'),'');
                                        ?>
                                        <strong for=""><?php echo e(__('administrator.employee')); ?></strong>
                                        <?php echo Form::select('emp_id',$user , ['class' => 'form-control emp_id', 'id' => 'emp_id','autocomplete' => 'off','']); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <?php
                                            $branch = App\Models\Hr\HrBranch::pluck('name', 'id')->prepend(__('administrator.please_select'), '');
                                        ?>
                                        <strong for=""><?php echo e(__('administrator.branch')); ?></strong>
                                        <?php echo Form::select('branch_id', $branch, array('class' => 'form-control','autocomplete' => 'off','')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <?php
                                            $department = App\Models\Hr\HrDepartmentModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'));
                                        ?>
                                        <strong for=""><?php echo e(__('administrator.department')); ?></strong>
                                        <?php echo Form::select('department_id', $department, array('class' => 'form-control select2','autocomplete' => 'off','')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <?php
                                            $position = App\Models\Hr\HrPositionModel::pluck('english_name', 'id')->prepend(__('administrator.please_select'));
                                        ?>
                                        <strong for=""><?php echo e(__('administrator.position')); ?></strong>
                                        <?php echo Form::select('position_id', $position, array('class' => 'form-control select2','autocomplete' => 'off','')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.from_date')); ?></strong>
                                        <?php echo Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','autocomplete' => 'off','')); ?>

                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for=""><?php echo e(__('administrator.to_date')); ?></strong>
                                        <?php echo Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','autocomplete' => 'off','')); ?>

                                    </div>
                                </div>
                                <div class=" col-sm-12">
                                    <button class=" btn btn-sm btn-primary pull-right" type="button" onclick="search()"> <?php echo e(__('administrator.search')); ?></button>
                                    <button class=" btn btn-sm btn-success pull-right" type="button" onclick="tableToExcel('print_tables','employee by branch')"><i class="fa fa-file-excel"></i> <?php echo e(__('administrator.excel')); ?></button>
                                    <button class=" btn btn-sm btn-info pull-right print_button" type="button" data-text="<?php echo e(__('administrator.report_attendance')); ?>" ><i class="fa fa-print "></i> <?php echo e(__('administrator.print')); ?></button>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table">
                <table id="print_table" width="100%" class="table table-striped table-hover ">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th><?php echo e(__('administrator.employee')); ?></th>
                            <th><?php echo e(__('administrator.total')); ?></th>
                            <th><?php echo e(__('administrator.before')); ?></th>
                            <th><?php echo e(__('administrator.bot')); ?></th>
                            <th><?php echo e(__('administrator.ot_type')); ?></th>
                            <th><?php echo e(__('administrator.total_ot')); ?></th>
                            <th><?php echo e(__('administrator.total_sun')); ?></th>
                            <th><?php echo e(__('administrator.total_hol')); ?></th>
                            <th><?php echo e(__('administrator.missing')); ?></th>
                            <th><?php echo e(__('administrator.late')); ?></th>

                        </tr>
                    </thead>
                    <tbody class="tbody">

                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "<?php echo e(route('get-report-attendance')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'employee','searchable': false},
                        {data: 'total','searchable': false},
                        {data: 'before','searchable': false},
                        {data: 'bot', 'searchable': false},
                        {data: 'ot_type', 'searchable': false},
                        {data: 'total_ot', 'searchable': false},
                        {data: 'total_sun', 'searchable': false},
                        {data: 'total_hol', 'searchable': false},
                        {data: 'missing', 'searchable': false},
                        {data: 'late', 'searchable': false},
                    ],
                "scrollX": true
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
        function search(){
            var emp_id = $('select[name="emp_id"]').find(':selected').val();
            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: {
                    url:"<?php echo e(route('get-report-attendance')); ?>",
                    type:'POST',
                    data:{
                        emp_id:emp_id,
                        _token:"<?php echo e(csrf_token()); ?>"
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'employee','searchable': false},
                        {data: 'total','searchable': false},
                        {data: 'before','searchable': false},
                        {data: 'bot', 'searchable': false},
                        {data: 'ot_type', 'searchable': false},
                        {data: 'total_ot', 'searchable': false},
                        {data: 'total_sun', 'searchable': false},
                        {data: 'total_hol', 'searchable': false},
                        {data: 'missing', 'searchable': false},
                        {data: 'late', 'searchable': false},

                    ],
                "scrollX": true
            });
            $.fn.dataTable.ext.errMode = 'throw';
        }
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/report-attendance/list-attendance-details.blade.php ENDPATH**/ ?>