<?php $__env->startSection("content"); ?>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> <?php echo e(__("application.List")); ?> <?php echo e(__("application.Supplier")); ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("application.Dashboard")); ?></a></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Construction Management")); ?></li>
               <li class="breadcrumb-item active"><?php echo e(__("application.Supplier")); ?></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="<?php echo e(route('suppliers.create')); ?>"> <?php echo e(__("application.Create New")); ?></a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-suppler" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th><?php echo e(__("application.No")); ?></th>
                  <th><?php echo e(__("application.Image")); ?></th>
                  <th><?php echo e(__("application.Name")); ?></th>
                  <th><?php echo e(__("application.Phone")); ?></th>
                  <th><?php echo e(__("application.Description")); ?></th>
                  <th><?php echo e(__("application.Action")); ?></th>
                </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key+1); ?></td>
                        <td><img src="<?php echo e(!empty($value->image)?asset('assets/img/upload'."/".$value->image):asset('assets/img/defaultphoto.png')); ?>" border="0" width="100px" height="80px" class="img-rounded" align="center" /></td>
                        <td><?php echo e($value->supp_name); ?></td>
                        <td><?php echo e($value->supp_phone); ?></td>
                        <td><?php echo e($value->supp_des); ?></td>
                        <td> <a href="<?php echo e(Route("suppliers.edit", Crypt::encrypt($value->id))); ?>"  class="btn btn-success btn-sm" data-toggle="tooltip" data-placement="top" title="Edit"><i class="fas fa-edit"></i></a></td>
                    </tr>
                    <div class="modal fade" id="edit-form_<?php echo e($value->id); ?>">
                      <div class="modal-dialog modal-lg">
                        <form class="form-horizontal" role="form" action="<?php echo e(route('suppliers.update')); ?>" method="post" name="cat">
                          <?php echo csrf_field(); ?>
                        <div class="modal-content">
                          <div class="modal-header">
                            <h4 class="modal-title">Edit form</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                          </div>
                          
                          <div class="modal-body">
                            <input type="hidden" name="id" id="id" value="<?php echo e($value->id); ?>">
                            <div class="form-group">
                                <strong class="required"><?php echo e(__("application.Supplier")); ?> <?php echo e(__("application.Name")); ?>:</strong>
                                <input type="text" name="supp_name" class="form-control  " id="name" value="<?php echo e($value->supp_name); ?>" placeholder="supplier name" required="true">
                            </div>
                            <div class="form-group">
                                <strong class="required"><?php echo e(__("application.Phone")); ?>:</strong>
                                <input name="supp_phone" class="form-control  " id="des" placeholder="phone number" value="<?php echo e($value->supp_phone); ?>">
                            </div>
                            <div class="form-group">
                                <strong><?php echo e(__("application.Description")); ?>:</strong>
                                <?php echo Form::textarea('supp_des', $value->supp_des, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>3)); ?>

                            </div>
                            <div class="form-group">
                                  <strong><?php echo e(__("application.Photo")); ?></strong>
                                  <img src="<?php echo e(asset('assets\img\defaultphoto.png')); ?>" style="display: none;" id="default-photo">
                                  <div style="width: 154px;height: 100px;">
                                      <?php if(!empty($value->image)): ?>
                                          <img src="<?php echo e(asset('assets/img/upload/'.$value->image)); ?>" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                      <?php else: ?>
                                          <img src="<?php echo e(asset('assets/img/defaultphoto.png')); ?>" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                      <?php endif; ?>
                                      
                                  </div>
                                  <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()"><?php echo e(__("application.Remove")); ?></button>
                                  <label class="custom-file-upload">
                                      <input type="hidden" name="cpImage" value="<?php echo e($value->image); ?>" id="cpImage">
                                      <input type="file" id="file-image-ageny" name="image" onchange="previewImage(event)" />
                                      <i class="fas fa-cloud-upload-alt"></i> <?php echo e(__("application.Upload")); ?>

                                  </label>
                              </div>
                          </div>
                          <div class="modal-footer justify-content-between">
                            <div>&nbsp;</div>
                            <button type="submit" class="btn btn-success btn-sm"><?php echo e(__("application.Submit")); ?></button>
                          </div>
                        </div>
                        </form>
                        <!-- /.modal-content -->
                      </div>
                      <!-- /.modal-dialog -->
                    </div>
                    <!-- /.modal -->
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function RemoveImage(){
      alert("OK");
        var imageField = document.getElementById("image-field");
        var resource = document.getElementById("default-photo");
        var imge = document.getElementById("file-image-ageny");
        imge.value="";
        imageField.src = resource.src;
        document.getElementById("cpImage").value="";
    }
    function previewImage(event){
        var reader = new FileReader();
        var imageField = document.getElementById("image-field");
        reader.onload = function(){
            if(reader.readyState == 2){
                imageField.src = reader.result;
            }
        }

        reader.readAsDataURL(event.target.files[0]);
    }
</script>
<script>  
  $(document).ready(function  () {
    $("#datable-suppler").DataTable({
      "scrollY": screen.height,
      "scrollX": true,
    });
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/suppliers/index.blade.php ENDPATH**/ ?>