<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('hr.overtime-request.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php Fun::lang()?>
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo e(__('administrator.are_you_sure')); ?></h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <form role="form" method="POST" id="form_update">
                    <?php echo e(csrf_field()); ?>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-12">
                                <input type="hidden" name="id" id="id">
                            </div>
                            <div class="form-group col-sm-12 col-xs-12">
                                <label class="required"><?php echo e(__('administrator.status')); ?></label>
                                <select name="status" class="form-control input-lg" required>
                                    <option value=""><?php echo e(__('administrator.please_select')); ?></option>
                                    <option value="1"><?php echo e(__('administrator.approve')); ?>

                                    </option>
                                    <option value="2"><?php echo e(__('administrator.reject')); ?>

                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                    class="fa fa-close"></i> <?php echo e(__('administrator.close')); ?>

                        </button>
                        <button type="submit" class="btn btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> <?php echo e(__('administrator.save')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title"><?php echo e(__('administrator.info_detail')); ?> </h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <div class="row">
                    <div class="col-sm-12">
                        <table class="table">
                            <tr>
                                <td><?php echo e(__('administrator.employee')); ?></td>
                                <td><span class="emp"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.project')); ?></td>
                                <td><span class="project"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.date')); ?></td>
                                <td><span class="date"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.from')); ?></td>
                                <td><span class="start"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.to')); ?></td>
                                <td><span class="end"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.note')); ?></td>
                                <td><span class="note"></span></td>
                            </tr>
                            <tr>
                                <td><?php echo e(__('administrator.status')); ?></td>
                                <td><span class="status"></span></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                class="fa fa-close"></i> <?php echo e(__('administrator.close')); ?>

                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__("administrator.overtime")); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.manage_hr")); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__("administrator.overtime")); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Overtime Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-overtime-request.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('administrator.employee')); ?></th>
                                        <th><?php echo e(__('administrator.project')); ?></th>
                                        <th><?php echo e(__('administrator.date')); ?></th>
                                        <th><?php echo e(__('administrator.from')); ?></th>
                                        <th><?php echo e(__('administrator.to')); ?></th>
                                        <th><?php echo e(__('administrator.total_hour')); ?></th>
                                        <th><?php echo e(__('administrator.ot_rate')); ?></th>
                                        <th><?php echo e(__('administrator.ot_type')); ?></th>
                                        <th><?php echo e(__('administrator.status')); ?></th>
                                        <th style="width: 250px;"><?php echo e(__('administrator.action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.delete-overtime', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                var url = "<?php echo e(route('hr.overtime-change-status')); ?>";
                $('#form_update').attr('action', url + '?id=' + id);
                $('#myModal').modal('show');
            });
            $(document).on('click', '.viewot', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "<?php echo e(route('hr.overtime')); ?>",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.emp').text(data.datas.employee);
                        $('.project').text(data.datas.project);
                        $('.date').text(data.datas.dates);
                        $('.start').text(data.datas.starts);
                        $('.end').text(data.datas.ends);
                        $('.note').text(data.datas.note);
                        $('.status').html(data.datas.statuss);
                    }
                });
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "<?php echo e(route('datatable.hr-get-overtime')); ?>",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'project'},
                        {data: 'ot_date'},
                        {data: 'start'},
                        {data: 'end'},
                        {data: 'total_hour'},
                        {data: 'ot_rate'},
                        {data: 'ot_type'},
                        {data: 'status'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/overtime-request/index.blade.php ENDPATH**/ ?>