<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <?php echo $__env->make('hr.generate-salary.confirm-delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1><?php echo e(__('administrator.generate_attendance')); ?></h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(__("administrator.Dashboard")); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.manage_hr')); ?></li>
                            <li class="breadcrumb-item active"><?php echo e(__('administrator.generate_attendance')); ?></li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                <?php if(Gate::check('Generate Attendance Create')): ?>
                                    <a class="btn btn-sm btn-success" href="<?php echo e(route('hr-generate-attendance.create')); ?>"><span class="fa fa-plus"></span> <?php echo e(__("administrator.create_new")); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatables" width="100%" class="table table-striped">
                                <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('administrator.employee')); ?></th>
                                    <th><?php echo e(__('administrator.att_date')); ?></th>
                                    <th><?php echo e(__('administrator.cin')); ?></th>
                                    <th><?php echo e(__('administrator.cout')); ?></th>
                                    <th><?php echo e(__('administrator.otin')); ?></th>
                                    <th><?php echo e(__('administrator.otout')); ?></th>
                                    <th><?php echo e(__('administrator.total')); ?></th>
                                    <th><?php echo e(__('administrator.late')); ?></th>
                                    <th><?php echo e(__('administrator.before')); ?></th>
                                    <th><?php echo e(__('administrator.ot')); ?></th>
                                    <th><?php echo e(__('administrator.ot_type')); ?></th>
                                    <th><?php echo e(__('administrator.missing')); ?></th>
                                    <th><?php echo e(__('administrator.total_hol')); ?></th>
                                    <th><?php echo e(__('administrator.total_sun')); ?></th>
                                    <th><?php echo e(__('administrator.total_ot')); ?></th>
                                    <th><?php echo e(__('administrator.action')); ?></th>
                                </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatables').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "<?php echo e(route('hr-generate-attendance.index')); ?>",
                "scrollX": true,
                lengthMenu: [[20, 50, 100, 500, 100], [20, 50, 100, 500, 100]],
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'employee'},
                        {data: 'att_date'},
                        {data: 'cin'},
                        {data: 'cout'},
                        {data: 'otin'},
                        {data: 'otout'},
                        {data: 'total'},
                        {data: 'late'},
                        {data: 'before'},
                        {data: 'ot'},
                        {data: 'ot_type'},
                        {data: 'missing'},
                        {data: 'total_hol'},
                        {data: 'total_sun'},
                        {data: 'total_ot'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/hmps/resources/views/hr/generate-attendance/index.blade.php ENDPATH**/ ?>