@extends("layouts.master")
@section("content")
<div class="modal fade" id="create-payment-policy">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Create")}} {{__('application.Policy')}} {{__('application.Payment')}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form class="form-horizontal" role="form" action="{{ route('payment-policy.store') }}" method="post">
      @csrf
      <div class="modal-body">
        <div class="form-group">
            <strong class="required">{{__("application.Name")}}:</strong>
            {!! Form::text('name', null, array('placeholder' =>__("application.Name"),'class' => 'form-control','required')) !!}
        </div>
        <div class="form-group">
            <strong>{{__("application.Description")}}:</strong>
            {!! Form::textarea('description', null, array('placeholder' =>__("application.Description"),'class' => 'form-control','rows'=>3)) !!}
        </div>
      </div>
      <div class="modal-footer justify-content-between">
        <div>&nbsp;</div>
        <button type="submit" class="btn btn-success btn-sm"><i class="fa fa-save"></i> {{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!--Edot Modal-->
<div class="modal fade" id='edit-payment-policy'>
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">{{__("application.Edit")}} {{__('application.Policy')}} {{__('application.Payment')}}</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form class='form-horizontal' role='form' action="{{route('payment-policy.update')}}" method='post'>
      @csrf
      <div class="modal-body">
        <div class="form-group">
            <strong class="required">{{__("application.Name")}}:</strong>
            {!! Form::text('name', null, array('placeholder' =>__("application.Name"),'class' => 'form-control','required','id'=>'name')) !!}
            <input type='hidden' name='id' id='id'>
        </div>
        <div class="form-group">
            <strong>{{__("application.Description")}}:</strong>
            {!! Form::textarea('description', null, array('placeholder' =>__("application.Description"),'class' => 'form-control','rows'=>3,'id'=>'description')) !!}
        </div>
      </div>
      <div class="modal-footer justify-content-between">
        <div>&nbsp;</div>
        <button type="submit" class="btn btn-success btn-sm"><i class="fa fa-save"></i> {{__("application.Save")}}</button>
      </div>
      {!! Form::close() !!}
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__('application.Policy')}} {{__('application.Payment')}} {{__('application.List')}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Setting")}}</li>
              <li class="breadcrumb-item active">{{__('application.Policy')}} {{__('application.Payment')}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="#create-payment-policy" data-toggle="modal">{{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-commission-condition" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                   {!!$data!!}
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
    function edit(obj)
    {
        var id = $(obj).data("id");
        var name = $(obj).data("name");
        var description = $(obj).data("description");
            $("#edit-payment-policy").modal("show");
            $("#name").val(name);
            $("#description").val(description);
            $("#id").val(id);
        
    }
    $(document).ready(function() {
        $('#datable-commission-condition').DataTable();
    });
    function delete_promotion(obj)
    {
        var id = $(obj).data("id");
        $.confirm({
            title:'Are you sure ?',
            content:'',
            theme:'modern',
            buttons:{
                cancel:{
                    btnClass:'btn btn-primary',
                    text:'Cancel',
                    action:function () {

                    }
                },
                submit:{
                    btnClass:'btn btn-danger',
                    text:"Delete",
                    action:function () {
                            window.location.replace('{{route("payment-policy.delete")}}?id='+id);
                    }
                },
            },
        });
    }
</script>
@endsection
<style>
    .modal-lg {
        width: 800px;
    }
</style>