@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__('application.Policy')}} {{__('application.Payment')}} {{__('application.Detail')}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Setting")}}</li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__('application.Policy')}} {{__('application.Payment')}} {{__('application.Detail')}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::model($data, ['method' => 'PATCH','route' => ['payment-policy-detail.update', $data->id],'enctype'=>'multipart/form-data','autocomplete'=>'off']) !!}
                @csrf
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-sm-4 col-xs-12">
                                <label class="required">Payment Policy </label>
                                {!! Form::select('payment_policy',$payment_policy, $data->policy_id, ['class' => 'form-control select2','required']) !!}
                            </div>
                            <div class="form-group col-sm-4 col-xs-12">
                                <label class="required">Category Item</label>
                                {!! Form::select('category_id[]',$categories,$categories_opt, ['class' => 'form-control select2','required','multiple']) !!}
                            </div>
                            <div class="form-group col-sm-4 col-xs-12">
                                <label class="required">Sub Category Item</label>
                                {!! Form::select('sub_category_id[]',$sub_categories,$sub_categorys_opt, ['class' => 'form-control select2','required','multiple']) !!}
                            </div>
                            <div class="form-group col-sm-4 col-xs-12">
                                <label class="required">Payment Policy Detail Name</label>
                                {!! Form::text('name', $data->name, ['class' => 'form-control','required']) !!}
                            </div>
                            <div class="form-group col-sm-4 col-xs-12">
                                <label class="required">Loan Generate Type</label>
                                {!! Form::select('loan_generate_type',['0'=>'Please Select','1'=>'Loan without interest','2'=>'Loan with interest','3'=>'Loan with interest (interest is changeable)','4'=>'Loan interest only'], $data->loan_generate_type, ['class' => 'form-control select2','required','id'=>'loan_generate_type']) !!}
                            </div>
                            <div class="form-group col-sm-4 col-xs-12" id="number_month_generate">
                                @if($data->loan_generate_type==2||$data->loan_generate_type==3)
                                <?php $data_details = DB::table('nso007_payment_policy_detail_loan_with_interest')->where("payment_policy_detail_id",$data->id)->first(); ?>
                                <label class="required">Loan Type</label>
                                {!! Form::select('loan_type',['1'=>'បង់រំលោះថេរ','2'=>'បង់រំលោះថយ'],$data_details->loan_type, ['class' => 'form-control select2','required','id'=>'loan_type-id']) !!}
                                @endif
                                @if($data->loan_generate_type==1)
                                <?php  $data_details = DB::table("nso007_payment_policy_detail_loan_without_interest")->where("payment_policy_detail_id",$data->id)->orderBy("id","ASC")->get(); ?>
                                <label class="required">Number of Month</label>
                                {!! Form::text('months_number',count($data_details), ['class' => 'form-control','required','id'=>'months_number-id']) !!}
                                @endif
                            </div>
                        </div>
                        <div class="row" id="number_month_generate_row">
                            @if($data->loan_generate_type==2||$data->loan_generate_type==3)
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required">Term</label>
                                    {!! Form::text('term','Month', ['class' => 'form-control','required','readonly']) !!}
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required">Duration</label>
                                    {!! Form::text('duration',$data_details->duration, ['class' => 'form-control','required','id'=>'duration-id']) !!}
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required">Interest</label>
                                    {!! Form::text('interest',$data_details->interest, ['class' => 'form-control','required','id'=>'interest-id']) !!}
                                </div>
                            @endif
                        </div>
                        <div class="row" id="change_rate_condition" style="padding: 15px;">
                            <?php
                                if($data->loan_generate_type==1){

                                    foreach($data_details as $key=>$value){
                                        echo ' <table class="table table-striped table-bordered">
                                                    <tbody class="rate-condition-appending">
                                                    <tr>
                                                        <td width="8%">
                                                        <label class="control-label required"><strong>ខែទី'.($key+1).' (%)</strong></label>
                                                        </td>
                                                        <td>
                                                        <input type="text" required class="form-control number-only" name="percentage_of_amount[]" placeholder="ភាគរយនៃទឹកប្រាក់" value="'.$value->percentage_of_amount.'">
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>';
                                    }
                                }
                            ?>
                            @if($data->loan_generate_type==3)
                                <?php $change_interests = DB::table('nso007_payment_policy_detail_loan_change_interest')->where("payment_policy_detail_id",$data->id)->orderBy("id","ASC")->get(); ?>
                                <div style="border-bottom: 2px solid #4CAF50">Change Rate Conditions<span class="pull-right button_primary btn-sm plus_ens fa fa-plus add-change-rate-option"></span></div>
                                <br />

                                <table class="table table-striped table-bordered">
                                <tbody class="rate-condition-appending">
                                    @foreach($change_interests as $i=>$change_interest)
                                    <tr>
                                        <td width="8%">
                                            <label class="control-label required"><strong> From Month: </strong></label>
                                        </td>
                                        <td>
                                            <input type="text" required class="form-control number-only change_rate_from  number-only" name="change_rate_from[]" placeholder="Rank of Month" value="{{ $change_interest->from_month }}">
                                        </td>
                                        <td width="9%">
                                            <label class="control-label required"><strong> To Month: </strong></label>
                                        </td>
                                        <td>
                                            <input type="text" value="{{ $change_interest->to_month }}" required name="change_rate_to[]" class="number-only form-control change_rate_to  number-only" placeholder="Rank of Month">
                                        </td>
                                        <td width="7%">
                                            <label class="control-label required"><strong> Rate : </strong></label>
                                        </td>
                                        <td>
                                            <input type="text" value="{{ $change_interest->interest }}" required name="rate_condition[]" class="number-only form-control rate_condition" placeholder="Interest">
                                        </td>
                                        @if($i==0)
                                        <td><button type="button" class="btn btn-sm btn-danger" disabled><i class="fas fa-trash"></i></button></td>
                                        @else
                                        <td><button type="button" class="btn btn-sm btn-danger" onclick="$(this).closest('tr').remove();"><i class="fas fa-trash"></i></button></td>
                                        @endif
                                    </tr>
                                    @endforeach
                                </tbody>
                                </table><br><br />

                            @endif
                        </div>
                        <div id="bwi-append">
                            <br/><br/>
                            <h3 class="loan-generate-info"></h3>
                            <div class="row loan-generate-info-for-append" style="padding: 15px;">

                            </div>
                        </div>
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
    $(document).on("keyup","#months_number-id",function(){
        var $_value = $(this).val();
        var div = ``;
        for(var i = 0 ; i<$_value;i++){
            div += `<table class="table table-striped table-bordered">
                        <tbody class="rate-condition-appending">
                        <tr>
                            <td width="8%">
                            <label class="control-label required"><strong>ខែទី${i+1} (%)</strong></label>
                            </td>
                            <td>
                            <input type="text" required class="form-control number-only" name="percentage_of_amount[]" placeholder="ភាគរយនៃទឹកប្រាក់">
                            </td>
                        </tr>
                        </tbody>
                    </table>`;
        }
        $("#number_month_generate_row").html('');
        $("#change_rate_condition").html(div);
    });
    $(document).on("change","#loan_generate_type",function(){
        var $_this_value =$(this).val();
        if($_this_value==1){
            $("#number_month_generate").html(`<label class="required">Number of Month</label>
                        {!! Form::text('months_number',null, ['class' => 'form-control','required','id'=>'months_number-id']) !!}`);
            $("#number_month_generate_row").html(``);
            $("#change_rate_condition").html(``);
        }
        else{
            $("#number_month_generate").html(``);
            if($_this_value==2){
                $("#number_month_generate").html(`
                    <label class="required">Loan Type</label>
                    {!! Form::select('loan_type',['1'=>'បង់រំលោះថេរ','2'=>'បង់រំលោះថយ'],null, ['class' => 'form-control select2','required','id'=>'loan_type-id']) !!}
                `);
                $("#number_month_generate_row").html(`
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Term</label>
                        {!! Form::text('term','Month', ['class' => 'form-control','required','readonly']) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Duration</label>
                        {!! Form::text('duration',null, ['class' => 'form-control','required','id'=>'duration-id']) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Interest</label>
                        {!! Form::text('interest',null, ['class' => 'form-control','required','id'=>'interest-id']) !!}
                    </div>
                `);
                $("#change_rate_condition").html(``);
            }
            else if($_this_value==3){
                $("#number_month_generate").html(`
                    <label class="required">Loan Type</label>
                    {!! Form::select('loan_type',['1'=>'បង់រំលោះថេរ','2'=>'បង់រំលោះថយ'],null, ['class' => 'form-control select2','required','id'=>'loan_type-id']) !!}
                `);
                $("#number_month_generate_row").html(`
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Term</label>
                        {!! Form::text('term','Month', ['class' => 'form-control','required','readonly']) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Duration</label>
                        {!! Form::text('duration',null, ['class' => 'form-control','required','id'=>'duration-id']) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-12">
                        <label class="required">Interest</label>
                        {!! Form::text('interest',null, ['class' => 'form-control','required','id'=>'interest-id']) !!}
                    </div>
                `);
                $("#change_rate_condition").html(`
                            <div style="border-bottom: 2px solid #4CAF50">Change Rate Conditions<span class="pull-right button_primary btn-sm plus_ens fa fa-plus add-change-rate-option"></span></div>
                            <br />
                            <table class="table table-striped table-bordered">
                              <tbody class="rate-condition-appending">
                                <tr>
                                  <td width="8%">
                                    <label class="control-label required"><strong> From Month: </strong></label>
                                  </td>
                                  <td>
                                    <input type="text" required class="form-control number-only change_rate_from  number-only" name="change_rate_from[]" placeholder="Rank of Month">
                                  </td>
                                  <td width="9%">
                                    <label class="control-label required"><strong> To Month: </strong></label>
                                  </td>
                                  <td>
                                    <input type="text" required name="change_rate_to[]" class="number-only form-control change_rate_to  number-only" placeholder="Rank of Month">
                                  </td>
                                  <td width="7%">
                                    <label class="control-label required"><strong> Rate : </strong></label>
                                  </td>
                                  <td>
                                    <input type="text" required name="rate_condition[]" class="number-only form-control rate_condition" placeholder="Interest">
                                  </td>
                                  <td><button type="button" class="btn btn-sm btn-danger" disabled><i class="fas fa-trash"></i></button></td>
                                </tr>
                              </tbody>
                            </table><br><br />
                `);
            }
        }
        $(".select2").select2();
    });
    $(document).on("click",".add-change-rate-option",function()
    {
        $(".rate-condition-appending").append(`<tr>
                <td width="8%">
                <label class="control-label"><strong> From Month: </strong></label>
                </td>
                <td>
                <input type="text" class="form-control number-only change_rate_from" name="change_rate_from[]" placeholder="Rank of Month">
                </td>
                <td width="9%">
                <label class="control-label"><strong> To Month: </strong></label>
                </td>
                <td>
                <input type="text" name="change_rate_to[]" class="number-only form-control change_rate_to" placeholder="Rank of Month">
                </td>
                <td width="7%">
                <label class="control-label"><strong> Rate : </strong></label>
                </td>
                <td>
                <input type="text" name="rate_condition[]" class="number-only form-control rate_condition" placeholder="Interest">
                </td>
                <td><button type="button" class="btn btn-sm btn-danger" onclick="$(this).closest('tr').remove();"><i class="fas fa-trash"></i></button></td>
            </tr>`);
    });
</script>
@endsection
