@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Report")}} {{__("application.Commission History")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Report")}} {{__("application.Commission History")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @include("report.operation.commission_history-form-search",compact("categories","projects","items"))
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-commission_history" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Date")}}</th>
                  <th>{{__("application.Item")}}</th>
                  <th>{{__("application.Project")}}</th>
                  <th>{{__("application.Category")}}</th>
                  <th>{{__("application.Agency")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Agency")}} {{__("application.Phone")}}</th>
                  <th>{{__("application.Gender")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Commission")}} {{__("application.Amount")}}($)</th>
                  <th>{{__("application.Amount")}} {{__("application.Withdraw")}}($)</th>
                  
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).on("change","#project-id",function(){
    $.ajax({
      url:"{{ route('operation.get_commission_history') }}",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        "request_type":"project",
        "project_id":$(this).val(),
        "category_id":$("category-id").val()
      },
      success:function(data){
        $("#item-id").empty();
        var opt = `<option value="">
                        Please Select
                     </option>`;
          $("#item-id").append(opt);
        $.each(data,function(index,val){
          var opt = `<option value="${val.id}">
                        ${val.name}
                     </option>`;
          $("#item-id").append(opt);
        });
      }
    });
  });
  $(document).ready(function() {
      $('.main-spinner').show();
       var commission_amount;var amount;
      $('#datable-commission_history').DataTable({  
          "autoWidth": false,
          ordering: false,
          responsive: false, 
          serverSide: true,
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: "{{ route('operation.get_commission_history') }}",
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false},
              {data: 'date','searchable': false},
              {data: 'item_name','name':'nso007_item_stock.name'},
              {data: 'project_name','name':'nso007_project_stock.name'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'agency_name','name':'nso007_agency.name'}, 
              {data: 'agency_phone','name':'nso007_agency.phone'},  
              {data: 'agency_gender','name':'nso007_agency.gender'} ,
              {data:'description','searchable': false},
              {data:'commission_amount','searchable': false},
              {data:'amount','searchable': false}
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
              $("#datable-commission_history").append(`<tr id='footer-data'>
                    <td colspan="9" class="text-right">{{__("application.Total")}}</td>
                    <td id="Principle">$${commission_amount}</td>
                    <td id="Interest">$${amount}</td>
                  </tr>`);
          },
          'footerCallback': function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
  

            commission_amount = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            amount = api
                .column( 10 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );


            // var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
            // $( api.column( 8 ).footer() ).html(currentcyFormat(Principle));
            // $( api.column( 9 ).footer() ).html(currentcyFormat(Interest));
            // $( api.column( 10 ).footer() ).html(currentcyFormat(Total_pay));
        }
      }); 
      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on('click','#search-form',function() {
          $(".main-spinner").show();
          var category_id = $("#category-id").val();
          var item_id = $("#item-id").val();
          var project_id = $("#project-id").val();
          var agency_gender = $("#agency-gender").val();
          var agency_name = $("#agency-name").val();
          var agency_phone = $("#agency-phone").val();
          var start_date = $("#start-date").val();
          var end_date = $("#end-date").val();
          $.ajax({
            url:"{{ route('operation.get_commission_history') }}",
            type:"POST",
            dataType:"JSON",
            data:{
              "_token":"{{csrf_token()}}",
              "category_id":category_id,
              "item_id":item_id,
              "project_id":project_id,
              "agency_gender":agency_gender,
              "agency_name":agency_name,
              "agency_phone":agency_phone,
              "start_date":start_date,
              "end_date":end_date
            },
            success:function (data) {
              $(".main-spinner").hide();
              $("#datable-commission_history tbody").empty();
              var commission_amount=0;var amount=0;
              $.each(data['commission_history'],function (index,val) {
                commission_amount+=Number(val.commission_amount);
                amount+=Number(val.amount);
                var tr = `<tr>
                            <td>${index+1}</td>
                            <td>${val.date.split("-")[2]+"-"+val.date.split("-")[1]+"-"+val.date.split("-")[0]}</td>
                            <td>${val.item_name}</td>
                            <td>${val.project_name}</td>
                            <td>${val.category_name}</td>
                            <td>${val.agency_name}</td>
                            <td>${val.agency_phone}</td>
                            <td>${val.agency_gender}</td>
                            <td>${val.description}</td>
                            <td>$${val.commission_amount}</td>
                            <td>$${val.amount}</td>
                          </tr>`;

                $("#datable-commission_history tbody").append(tr);
              });

              $("#datable-commission_history tbody").append(`<tr id='footer-data'>
                  <td colspan="9" class="text-right">Total</td>
                  <td id="Principle">$${commission_amount}</td>
                  <td id="Interest">$${amount}</td>
                </tr>`);

              $('#datable-item_info').hide();
              $('#datable-item_paginate').hide();
              $('#datable-item_length').hide();
            }
          });
  });
  function print(){
    var title=`Report Commission History`;
    var user_name = "{{Auth::user()->name}}";
    var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
    var table_data = $("#datable-commission_history").html();
    print_report(title,table_data,user_name,date);// Refference at master page
  }
</script>
@endsection