@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Report Collection")}} </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Report Collection")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @include("report.operation.collection-form-search",compact("categories","projects","items"))
            <!-- /.card-header -->
            <div class="card-body table-responsive">
              <table id="datable-collection" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Due Date")}}</th>
                  <th>{{__("application.Item")}}</th>
                  {{-- <th>{{__("application.Project")}}</th> --}}
                  <th>{{__("application.Category")}}</th>
                  <th>{{__("application.Client")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Gender")}}</th> 
                  <th>{{__("application.Payment")}} {{__("application.Policy")}}</th> 
                  <th>{{__("application.Principal")}}</th>
                  <th>{{__("application.Interest")}}</th>
                  <th>{{__("application.Total")}} {{__("application.Amount")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
                <tfoot1>
                  <tr id='footer-data'>
                    <td colspan="7" class="text-right">{{__("application.Total")}}&nbsp;</td>
                    <td id="Principle"></td>
                    <td id="Interest"></td>
                    <td id="total-pay"></td>
                  </tr>
                </tfoot1>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
  $(document).on("change","#project-id",function(){
    $.ajax({
      url:"{{ route('operation.get_collection') }}",
      type:"POST",
      dataType:"JSON",
      data:{
        "_token":"{{csrf_token()}}",
        "request_type":"project",
        "project_id":$(this).val(),
        "category_id":$("category-id").val()
      },
      success:function(data){
        $("#item-id").empty();
        var opt = `<option value="">
                        Please Select
                     </option>`;
          $("#item-id").append(opt);
        $.each(data,function(index,val){
          var opt = `<option value="${val.id}">
                        ${val.name}
                     </option>`;
          $("#item-id").append(opt);
        });
      }
    });
  });
  $(document).ready(function() {
      $('.main-spinner').show();
       var Principle;var Interest;var Total_pay;
      $('#datable-collection').DataTable({  
          "autoWidth": false,
          ordering: true,
          serverSide: true,
          responsive: false, 
          "searching": true,
          lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
          dom: 'Blfrtip',
          buttons: [
              {
                  text:      '<i class="fa fa-search"></i>',
                  titleAttr: 'Filter',
                  className: "btn btn-default btn-md",
                  attr:  {
                      id: 'btn-search',
                      onclick:"search_report(this)",
                      style:"background-color:#88B21F;color:white"

                  }
              },
              {
                  extend:    'excelHtml5',
                  text:      '<i class="far fa-file-excel"></i>',
                  titleAttr: 'Excel',
                  className: "btn btn-info btn-md"
              },
              {
                  text:      '<i class="fa fa-print"></i>',
                  titleAttr: 'Print',
                  className: "btn btn-success btn-md",
                  attr:  {
                      id: 'print-report-id',
                      onclick:"print(this)"
                  }
              },
          ],
          ajax: {
            url:"{{ route('operation.get_collection') }}",
            type:"GET",
            data:function(d){
              var category_id = $("#category-id").val();
              var item_id = $("#item-id").val();
              var project_id = $("#project-id").val();
              var client_gender = $("#client-gender").val();
              var client_name = $("#client-name").val();
              var client_phone = $("#client-phone").val();
              var start_date = $("#start-date").val();
              var end_date = $("#end-date").val();
              var payment_policy = $("#payment-policy").val();
              d.category_id=category_id;
              d.item_id=item_id;
              d.project_id=project_id;
              d.client_gender=client_gender;
              d.client_name=client_name;
              d.client_phone=client_phone;
              d.start_date=start_date;
              d.end_date=end_date;
              d.payment_policy = payment_policy;
              d.last_months = $("#last_months").val();
            }
          },
          columns: 
          [
              {data: 'DT_RowIndex','searchable': false,orderable: false},
              {data: 'date_payment','name':'nso007_loan_process.date_payment'},
              {data: 'item_name','name':'nso007_item_stock.name'},
              {data: 'category_name','name':'nso007_category_stock.name'},
              {data: 'client_name','name':'nso007_client.name'},   
              {data: 'client_gender','name':'nso007_client.gender'} ,
              {data: 'payment_policy','searchable': false},
              {data:'principle_pay','searchable': false},
              {data:'interest_amount_pay','searchable': false},
              {data:'owe_amount_pay','searchable': false}
          ],

          "columnDefs": [
            { "width": "85px", "targets": 1 },
          ],

          "initComplete": function(settings, json) {
              $('.main-spinner').hide();
              // $("#datable-collection tbody").append(`<tr id='footer-data'>
              //       <td colspan="8" class="text-right">Total&nbsp;</td>
              //       <td id="Principle">$${Principle.toFixed(4)}</td>
              //       <td id="Interest">$${Interest}</td>
              //       <td id="total-pay">$${Total_pay}</td>
              //     </tr>`);
          },
          'footerCallback': function ( row, data, start, end, display ) {
            var api = this.api(), data;
            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
  

            Principle = api
                .column( 7 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            Interest = api
                .column( 8 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );

            Total_pay = api
                .column( 9 )
                .data()
                .reduce( function (a, b) {
                    return intVal(a) + intVal(b);
                }, 0 );
            var currentcyFormat = $.fn.dataTable.render.number( '\,', '.', 2, '$' ).display;
            $("#Principle").html(currentcyFormat(Principle));
            $("#Interest").html(currentcyFormat(Interest));
            $("#total-pay").html(currentcyFormat(Total_pay));
        }
      }); 
      $.fn.dataTable.ext.errMode = 'throw';
  });
  $(document).on('click','#search-form',function(){
    $('#datable-collection').DataTable().draw(true);
  });
  function print(){
    var project_name = "";
    let i = 0;
    $("select#project-id option").each(function(index,value){
      if($(this).prop("selected")==true){
        i++;
        project_name += $(this).text();
        if(i<$("#project-id option:selected").length) project_name += " និង ";
      }
    });
    let p_name = '';
    if(project_name!=''){
      p_name = '( គម្រោង៖ '+project_name+' )';
    }
    var title=`Report Payment Collection`;
    var user_name = "{{Auth::user()->name}}";
    var date = "{{\Globals::date_khmers(date('d-m-Y'))}}";
    var table_data = $("#datable-collection").html();
    print_report_operation(title,table_data,user_name,date,p_name);// Refference at master page
  }
</script>
@endsection