@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Item")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item"><a href="{{route('item.index')}}">{{__("application.Item")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Item")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
    {!! Form::model($item, ['method' => 'PATCH','route' => ['item.update', $item->id]]) !!}
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Category")}}:</strong>
                                    {!! Form::select('category_id',$categories,null, array('class' => 'form-control select2','required','id'=>'category-id')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Block")}}:</strong>
                                    {!! Form::select('block_id',$blocks,null, array('class' => 'form-control select2','required','id'=>'display-block')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Cost")}}:</strong>
                                    {!! Form::number('cost',null, array('placeholder' => __("application.Cost"),'class' => 'form-control','id'=>'item-cost')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Price")}}:</strong>
                                    {!! Form::number('price', null, array('placeholder' => __("application.Price"),'class' => 'form-control','required','id'=>'item-price')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Subcategory")}}:</strong>
                                    {!! Form::select('subcategory_id',$subcategories,null, array('class' => 'form-control select2','required','id'=>'subcategory-id')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Group")}} {{__('application.Item')}}:</strong>
                                    {!! Form::select('groupitem_id',$groupitems,null, array('class' => 'form-control select2','required','id'=>'groupitem-id')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Item")}} {{__("application.Name")}}:</strong>
                                    {!! Form::text('name', null, array('placeholder' =>__("application.Item").__("application.Name"),'class' => 'form-control','required','id'=>'item-name')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Project")}}:</strong>
                                    {!! Form::select('project_id',$projects,null, array('class' => 'form-control select2','required','id'=>'project-id')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong class="required">{{__("application.Size")}}:(Ex:12mx16m)</strong>
                                    {!! Form::text('size', null, array('placeholder' =>__("application.Size"),'class' => 'form-control','required','id'=>'item-size')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}</strong>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'3')) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success fa fa-save"> {{__("application.Save")}} {{__("application.Change")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    {!! Form::close() !!}
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script>
    $(document).on("change","#project-id",function () {
        var id = $(this).val();
        var route="{{route("item.get_item")}}";
        $('.main-spinner').show();
        $.ajax({
            url:route,
            dataType:'JSON',
            type:"POST",
            data:{
                "_token":"{{csrf_token()}}",
                "project_id":id
            },
            success:function(data){
                $('.main-spinner').hide();
                var opt="<option value=''>Please Select</option>";
                $.each(data,function(index,val){
                    opt+=`<option value="${val.id}">${val.name}</option>`;
                });
                $("#display-block").empty();
                $("#display-block").append(opt);
            },
            error:function(){
                console.log("NO");
            }
        });
    });
</script>
@endsection