@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.training_course')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.training_course')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($training_course, ['method' => 'PATCH', 'route' => ['hr-training-course.update', $training_course->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.name')}}</label>
                                    {!! Form::text('name',null, array('placeholder' => __('administrator.please_select'), 'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.description')}}</label>
                                    {!! Form::text('description',null, array('placeholder' => __('administrator.please_select'), 'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                </div>
        
                                <div class="form-group col-sm-4 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.date')}}</label>
                                    {!! Form::text('date', $training_course->date ? date('d-m-Y', strtotime($training_course->date)) : date('d-m-Y'), array('class' => 'form-control date_picker','autocomplete'=> 'off')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection



