@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.new")}} {{__("administrator.salary_tax")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.salary_tax")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'salary-tax.store','method'=>'POST')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.name')}}</label>
                                            {!! Form::text('name', null, array('class' => 'form-control', 'required')) !!}
                                        
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <table width="100%" class="table" id="table-salary-tax">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Rate(%)</th>
                                                        <th>From Salary ( ៛ )</th>
                                                        <th>To Salary ( ៛ )</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="tbody-salary-tax">
                                                    <tr>
                                                        <td class="r-no">1</td>
                                                        <td><input type="number" name="rate_zero" value="" class="form-control" required></td>
                                                        <td><input type="number" name="from_salary_zero" value="" class="form-control" required></td>
                                                        <td><input type="number" name="to_salary_zero" value="" class="form-control" required></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="r-no">2</td>
                                                        <td><input type="number" name="rate_five" value="" class="form-control" required></td>
                                                        <td><input type="number" name="from_salary_five" value="" class="form-control" required></td>
                                                        <td><input type="number" name="to_salary_five" value="" class="form-control" required></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="r-no">3</td>
                                                        <td><input type="number" name="rate_ten" value="" class="form-control" required></td>
                                                        <td><input type="number" name="from_salary_ten" value="" class="form-control" required></td>
                                                        <td><input type="number" name="to_salary_ten" value="" class="form-control" required></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="r-no">4</td>
                                                        <td><input type="number" name="rate_fifteen" value="" class="form-control" required></td>
                                                        <td><input type="number" name="from_salary_fifteen" value="" class="form-control" required></td>
                                                        <td><input type="number" name="to_salary_fifteen" value="" class="form-control" required></td>
                                                    </tr>
                                                    <tr>
                                                        <td class="r-no">5</td>
                                                        <td><input type="number" name="rate_twenty" value="" class="form-control" required></td>
                                                        <td colspan="2"><input type="number" name="over_twenty" value="" class="form-control" required></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function(){
            $(document).on('click', '.add_new', function(){
                var row =  `<tr>
                                <td class="r-no"></td>
                                <td><input type="number" name="rate[]" value="" class="form-control" required></input></td>
                                <td><input type="number" name="from_salary[]" value="" class="form-control" required></input></td>
                                <td><input type="number" name="to_salary[]" value="" class="form-control" required></input></td>
                                <td><input type="number" name="add[]" value="" class="form-control" required></input></td>
                                <td><input type="number" name="minus[]" value="" class="form-control" required></input></td>
                                <td><button type="button" class="remove_row btn button_danger"><i class="fa fa-trash"></i></button></td>
                            </tr>`;
                $('.tbody-salary-tax').append(row);
                updateNo();
                stop();
            });
        });

        $(document).ready(function () {
            $(document).on('click', '.remove_row', function () {
                var index_ = $(this).data('index');
                $(this).closest('tr').remove();
                stop();
            });
        });

        function updateNo() 
        {
            $('.r-no').each(function (i,item) {
                $(this).text(i+1);
            });
        }
        function stop(){
            var array = [];
            var item = 1;
            $('.tbody-salary-tax tr').each(function(){
                array.push(item);
            });
            if(array.length > 4){
                $('.add_new').css('display','none');
            }else{
                $('.add_new').css('display','block');
            }
        }
    </script>
@endsection



