@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    @php
        
    @endphp
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.leave_by_group")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.leave_by_group")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card card-default">
                        <div class="card-body">
                            {!! Form::open(array('route' => 'get-report-employee','method'=>'get')) !!}
                            <div class="row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for="">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp_id', $user , null, ['class' => 'form-control select2','autocomplete' => 'off','']) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for="">{{__('administrator.from_date')}}</strong>
                                        {!! Form::text('from_date', null, array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker','id' => 'from_date','autocomplete' => 'off','')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <strong for="">{{__('administrator.to_date')}}</strong>
                                        {!! Form::text('to_date', null, array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','id' => 'to_date','autocomplete' => 'off','')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div style="text-align: right;">
                                        <button class=" btn btn-sm btn-primary pull-right" type="button" onclick="search()"><i class="fa fa-search "></i> {{__('administrator.search')}}</button>
                                        <button class=" btn btn-sm btn-success pull-right" type="button" onclick="tableToExcel('print_tables','employee by branch')"><i class="fa fa-file-excel"></i> {{__('administrator.excel')}}</button>
                                        <button class=" btn btn-sm btn-info pull-right print_button" type="button" data-text="{{__('administrator.leave_by_group')}}" ><i class="fa fa-print "></i> {{__('administrator.print')}}</button>
                                    </div>
                                </div>
                            </div>
                            {!! Form::close() !!}

                            <table id="print_table" width="100%" class="table table-striped table-hover ">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.code')}}</th>
                                        <th>{{__('administrator.employee')}}</th>
                                        <th>{{__('administrator.leave_type')}}</th>
                                        <th>{{__('administrator.request_date')}}</th>
                                        <th>{{__('administrator.from_date')}}</th>
                                        <th>{{__('administrator.to_date')}}</th>
                                        <th>{{__('administrator.total_day')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                "bFilter": false,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: "{{ route('get-report-leave-by-group') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', 'orderable': false, 'searchable': false},
                        {data: 'code','searchable': false},
                        {data: 'employee','searchable': false},
                        {data: 'leave_type', 'searchable': false},
                        {data: 'request_date', 'searchable': false},
                        {data: 'from_date', 'searchable': false},
                        {data: 'to_date', 'searchable': false},
                        {data: 'num_take_leave', 'searchable': false},
                    ],
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
        function search(){
            var emp_id          = $('select[name="emp_id"]').find(':selected').val();
            var from_date       = $('#from_date').val();
            var to_date         = $('#to_date').val();

            $('#print_table').DataTable().destroy();
            $('#print_table').DataTable({
                ordering: false,
                serverSide: true,
                "bFilter": false,
                lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
                ajax: {
                    url:"{{ route('get-report-leave-by-group') }}",
                    type:'POST',
                    data:{
                        emp_id:emp_id,
                        from_date:from_date,
                        to_date: to_date,
                        _token:"{{csrf_token()}}"
                    }
                },
                columns:
                    [
                        {data: 'DT_RowIndex', 'orderable': false, 'searchable': false},
                        {data: 'code','searchable': false},
                        {data: 'employee','searchable': false},
                        {data: 'leave_type', 'searchable': false},
                        {data: 'request_date', 'searchable': false},
                        {data: 'from_date', 'searchable': false},
                        {data: 'to_date', 'searchable': false},
                        {data: 'num_take_leave', 'searchable': false},

                    ],
            });
            $.fn.dataTable.ext.errMode = 'throw';
        }
    </script>
@stop




