@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.recommendation')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.recommendation')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($recommend, ['method' => 'PATCH','route' => ['hr-recommendation.update', $recommend->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-12 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::select('emp_id', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.request_to')}}</label>
                                    {!! Form::select('request_to', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <table class="table table-bordered" style="width: 100%">
                                        <thead>
                                        <tr style="text-align: center;background-color: lightcyan">
                                            <td colspan="4">Salary Increment</td>
                                            <td colspan="4">Performance Bonus</td>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr style="text-align: center">
                                            <td>{!! Form::radio('increment_comment','1', true) !!}</td>
                                            <td>Comment</td>
                                            <td>{!! Form::radio('increment_comment','0') !!}</td>
                                            <td>Not Comment</td>
                                            <td>{!! Form::radio('bonus_comment','1', true) !!}</td>
                                            <td>Comment</td>
                                            <td>{!! Form::radio('bonus_comment','0') !!}</td>
                                            <td>Not Comment</td>
                                        </tr>
                                        <tr>
                                            <td colspan="4">{!! Form::text('increment_date', date('m-d-Y',strtotime($recommend->increment_date)),array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}</td>
                                            <td colspan="4">{!! Form::text('bonus_date', date('m-d-Y',strtotime($recommend->bonus_date)),array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker')) !!}</td>
                                        </tr>
                                        <tr>
                                            <td colspan="4">{!! Form::textarea('increment_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                            <td colspan="4">{!! Form::textarea('bonus_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-bordered" style="width: 100%">
                                        <thead>
                                            <tr style="text-align: center;background-color: lightcyan">
                                                <td colspan="4">Promotion</td>
                                                <td colspan="4">New Opportunity</td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="text-align: center">
                                                <td>{!! Form::radio('promote_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('promote_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                                <td>{!! Form::radio('opportunity_comment','1', true) !!}</td>
                                                <td>Comment</td>
                                                <td>{!! Form::radio('opportunity_comment','0') !!}</td>
                                                <td>Not Comment</td>
                                            </tr>
                                            <tr>
                                                <td colspan="4">{!! Form::textarea('promote_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                                <td colspan="4">{!! Form::textarea('opportunity_description', null,array('placeholder' => __('administrator.description'),'class' => 'form-control')) !!}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

