@extends("layouts.master")

@section('content')
    @include('hr.overtime-request.confirm-delete')
    <?php Fun::lang()?>
    <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{ __('administrator.are_you_sure')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <form role="form" method="POST" id="form_update">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-12">
                                <input type="hidden" name="id" id="id">
                            </div>
                            <div class="form-group col-sm-12 col-xs-12">
                                <label class="required">{{ __('administrator.status')}}</label>
                                <select name="status" class="form-control input-lg" required>
                                    <option value="">{{ __('administrator.please_select')}}</option>
                                    <option value="1">{{ __('administrator.approve')}}
                                    </option>
                                    <option value="2">{{ __('administrator.reject')}}
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                    class="fa fa-close"></i> {{ __('administrator.close')}}
                        </button>
                        <button type="submit" class="btn btn-success" data-toggle="modal"><i
                                    class="fa fa-save"></i> {{ __('administrator.save')}}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="viewModal" tabindex="-2" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title">{{ __('administrator.info_detail') }} </h3>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                </div>
                <br/>
                <div class="row">
                    <div class="col-sm-12">
                        <table class="table">
                            <tr>
                                <td>{{ __('administrator.employee') }}</td>
                                <td><span class="emp"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.project') }}</td>
                                <td><span class="project"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.date') }}</td>
                                <td><span class="date"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.from') }}</td>
                                <td><span class="start"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.to') }}</td>
                                <td><span class="end"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.note') }}</td>
                                <td><span class="note"></span></td>
                            </tr>
                            <tr>
                                <td>{{ __('administrator.status') }}</td>
                                <td><span class="status"></span></td>
                            </tr>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-danger"><i
                                class="fa fa-close"></i> {{ __('administrator.close') }}
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.overtime")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.overtime")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Overtime Create')
                                    <a class="btn btn-sm btn-success" href="{{route('hr-overtime-request.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('administrator.employee')}}</th>
                                        <th>{{ __('administrator.project')}}</th>
                                        <th>{{ __('administrator.date')}}</th>
                                        <th>{{ __('administrator.from')}}</th>
                                        <th>{{ __('administrator.to')}}</th>
                                        <th>{{ __('administrator.total_hour')}}</th>
                                        <th>{{ __('administrator.ot_rate')}}</th>
                                        <th>{{ __('administrator.ot_type')}}</th>
                                        <th>{{ __('administrator.status')}}</th>
                                        <th style="width: 250px;">{{ __('administrator.action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.delete-overtime', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $(document).on('click', '.viewPopLink', function () {
                var id = $(this).data('id');
                var url = "{{route('hr.overtime-change-status')}}";
                $('#form_update').attr('action', url + '?id=' + id);
                $('#myModal').modal('show');
            });
            $(document).on('click', '.viewot', function () {
                var id = $(this).data('id');
                $('#viewModal').modal('show');
                $.ajax({
                    url: "{{route('hr.overtime')}}",
                    type: 'GET',
                    data: {
                        "id": id,
                    },
                    success: function (data) {
                        $('.emp').text(data.datas.employee);
                        $('.project').text(data.datas.project);
                        $('.date').text(data.datas.dates);
                        $('.start').text(data.datas.starts);
                        $('.end').text(data.datas.ends);
                        $('.note').text(data.datas.note);
                        $('.status').html(data.datas.statuss);
                    }
                });
            });

            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-overtime') }}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'emp_id'},
                        {data: 'project'},
                        {data: 'ot_date'},
                        {data: 'start'},
                        {data: 'end'},
                        {data: 'total_hour'},
                        {data: 'ot_rate'},
                        {data: 'ot_type'},
                        {data: 'status'},
                        {data: 'action', searchable: false},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
