@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.overtime")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.overtime")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($overtime, ['method' => 'PATCH','route' => ['hr-overtime-request.update', $overtime->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp_id',$employee ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.project')}}</strong>
                                        {!! Form::text('project', null, array('placeholder' => __('administrator.project'),'class' => 'form-control', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required"  for="name">{{__('administrator.date')}}</strong>
                                        {!! Form::text('date', null, array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="" for="name">{{__('administrator.time_in')}}</strong>
                                        <!-- time Picker -->
                                        <div class="bootstrap-timepicker ">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    {!! Form::text('start', null,array('class' => 'form-control timepicker')) !!}
                                                    <div class="input-group-addon">
                                                    <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="" for="name">{{__('administrator.time_out')}}</strong>
                                        <!-- time Picker -->
                                        <div class="bootstrap-timepicker ">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    {!! Form::text('end', null,array('class' => 'form-control timepicker')) !!}
                                                    <div class="input-group-addon">
                                                    <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="" for="name">{{__('administrator.hour')}}</strong>
                                        {!! Form::text('hours', null, array('placeholder' => __('administrator.hour'),'class' => 'form-control number-only', 'autocomplete'=>'off')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required" for="name">{{__('administrator.ot_type')}}</strong>
                                        {!! Form::select('ot_type',[
                                                ''=>__('administrator.please_select'),
                                                'ot_night_shift'=>__('administrator.ot_night_shift'),
                                                'ot_normal'=>__('administrator.ot_normal'),
                                                'ot_eight'=>__('administrator.ot_eight'),
                                                'ot_over_night'=>__('administrator.ot_over_night'),
                                                'ot_sunday'=>__('administrator.ot_sunday'),
                                                'ot_holiday'=>__('administrator.ot_holiday')]
                                                 ,null, array('class' => 'form-control select2','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="">
                                        <strong class="required" for="name">{{__('administrator.ot_rate')}}</strong>
                                        {!! Form::select('ot_rate',[
                                                ''=>__('administrator.please_select'),
                                                '1'=>'100%',
                                                '1.5'=>'150%',
                                                '2'=>'200%']
                                                ,null, array('class' => 'form-control select2','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class=" ">
                                        <strong class=""  for="name">{{__('administrator.reason')}}</strong>
                                        {!! Form::textarea('reason', null, array('placeholder' => __('administrator.reason'),'class' => 'form-control no-resize', 'autocomplete'=>'off','rows'=>'3')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class=" ">
                                        <strong class=""  for="name">{{__('administrator.note')}}</strong>
                                        {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control no-resize', 'autocomplete'=>'off','rows'=>'3')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

