@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.edit")}} {{__("administrator.overtime_policy")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.overtime_policy')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($overtime_policy, ['method' => 'PATCH','route' => ['overtime-policy.update', $overtime_policy->id],'id'=>'form-submit']) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.name')}}</label>
                                            {!! Form::text('name', null, array('placeholder'=>'Name', 'class' => 'form-control','required',)) !!}
                                        </div>
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.rate_normal_ot')}}</label>
                                            {!! Form::text('normal_ot_rate', null, array('placeholder' => __('administrator.rate_normal_ot'),'class' => 'form-control number-only','required')) !!}
                                        </div>
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.rate_sunday_ot')}}</label>
                                            {!! Form::text('sunsat_ot_rate', null, array('placeholder' => __('administrator.rate_sunday_ot'),'class' => 'form-control number-only','required')) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.rate_holiday_ot')}}</label>
                                            {!! Form::text('holiday_ot_rate', null, array('placeholder' => __('administrator.rate_holiday_ot'),'class' => 'form-control number-only','required')) !!}
                                        </div>
                                        <div class="form-group">
                                            <label class="required"  for="name">{{__('administrator.effect_date')}}</label>
                                            {!! Form::text('effect_date', date('m-d-Y', strtotime($overtime_policy->effect_date)), array('placeholder' => __('administrator.effect_date'),'class' => 'form-control date_picker','required')) !!}
                                        </div>
                                        <div class="form-group">
                                            <label class=""  for="name">{{__('administrator.note')}}</label>
                                            {!! Form::text('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control')) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection
@section('script')
    <script>
    </script>
@endsection




