@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    <div class="title-add">
        <div class="page-bar">
            <ul class="page-breadcrumb">
                <li> <a class="ng-binding" href="#"><i class="fa fa-dashboard"></i> Dashboard</a> </li>
                <li> <a href="#">Manage HR</a> </li>
                <li> <a class="ng-binding" href="#">{{__('administrator.leave')}}</a> </li>
            </ul>
        </div>
    </div>
    <div class="page">
        <div class="top-content">
            <div class="row">
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3>{{__('administrator.leave_list')}} </h3>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-12">
                    <div class="title-add">
                        <div class="pull-right">
                            <a href="{{route('hr-leave-request.create')}}"
                               class="button_primary">{{__('administrator.add_new')}}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box-body">
            <table id="datatable_products" width="100%" class="table table-striped">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{ __('administrator.employee') }}</th>
                    <th>{{__('administrator.leave_type')}}</th>
                    <th>{{__('administrator.from_date')}}</th>
                    <th>{{__('administrator.to_date')}}</th>
                    <th>{{__('administrator.reason')}}</th>
                    <th>{{__('administrator.status')}}</th>
                    <th>{{ __('administrator.action') }}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                ajax: "{{ route('datatable.hr-get-leave-staff') }}",
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'emp_id'},
                        {data: 'leave_type'},
                        {data: 'from_date'},
                        {data: 'to_date'},
                        {data: 'reason'},
                        {data: 'status'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
