{{-- {{dd($id, $job_post)}} --}}

<html>
    <head>
        <title>WareHouse</title>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="shortcut icon" href="https://upload.wikimedia.org/wikipedia/commons/a/ab/Android_O_Preview_Logo.png">
        <link rel="stylesheet" type="text/css" href="{{asset('css/styles.css')}}">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="{{asset('js/select2/select2.css')}}">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script> 
    </head>
<style>
    table {
        border-collapse: collapse;
    }

    table, th, td {
        border: 1px solid black;
        padding: 5px;
    }
    .container{
        width: auto;
        margin: 0 auto;
        
    }
    .battambong
    {
        font-family: khmer os battambang !important;
        font-size: 12px;
    }
    .arial
    {
        font-family: Arial, Helvetica, sans-serif, khmer os battambang !important;
        font-size: 12px;
    }
</style>
<div class="page">
    @if($job_post != "")
    
        <div class="row">
            <div class="col-sm-6">
                {{-- <h3 style="text-align: center;">Job Post</h3> --}}
                <table style="width:100%; border: 1px solid black;" class="arial table">
                    <thead>
                    </thead>
                    <tbody>
                        <tr >
                            <td >Job Title</td>
                            <td>{{$job_post->job_title}}</td>
                            <td>Year of Exp.</td>
                            <td>{{$job_post->exp_year}} years</td>
                        </tr>
                        <tr >
                            <td >Job function</td>
                            <td>{{optional($job_post->get_job_function)->name}}</td>
                            <td>Salary</td>
                            <td>({{$job_post->salary_min}} - {{$job_post->salary_max}}) $</td>
                        </tr>
                        <tr >
                            <td >Department</td>
                            <td>{{optional($job_post->get_department)->department_name}}</td>
                            <td>Location</td>
                            <td>{{optional($job_post->get_location)->province_en}}</td>
                        </tr>
                        <tr >
                            <td >Sex</td>
                            <td>{{$job_post->sex}}</td>
                            <td>Hiring</td>
                            <td>{{$job_post->hiring_amt}}</td>
                        </tr>
                        <tr >
                            <td >Age</td>
                            <td>({{$job_post->from_age}} - {{$job_post->to_age}}) years</td>
                            <td>Closing Date</td>
                            <td>{{$job_post->closing_date}}</td>
                        </tr>
                        <tr >
                            <td>Education level</td>
                            <td>{{optional($job_post->get_education_level)->name}}</td>
                            <td>Employment type</td>
                            <td>{{optional($job_post->get_employment)->name}}</td>
                        </tr>   
                    </tbody>
                </table>
            </div>
            
            <div class="col-sm-6">
                {!! Form::open(array('route' => 'hr.hr-view-job-post','method'=>'POST','enctype'=>'multipart/form-data')) !!}
                <div class=" col-sm-12">
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.first_name')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::text('first_name', null, array('placeholder' => __('administrator.first_name'),'class' => 'form-control input-sm' ,'autocomplete'=>'off','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.last_name')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::text('last_name', null, array('placeholder' => __('administrator.last_name'),'class' => 'form-control input-sm' ,'autocomplete'=>'off','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.sex')}}</label> 
                        </div>
                        <div class="col-sm-8">
                            {!! Form::select('sex',[''=> __('administrator.please_select'),'male'=>__('administrator.male'),'female'=>__('administrator.female')], array('class' => 'form-control input-sm select2','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.phone')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::text('phone', null, array('placeholder' => __('administrator.phone'),'class' => 'form-control number-only input-sm','autocomplete'=>'off','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required"  for="name">{{__('administrator.email')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::email('email', null, array('placeholder' => __('administrator.email'),'class' => 'form-control input-sm','autocomplete'=>'off','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-8">
                            {!! Form::hidden('job_post_id', $job_post->id, array('class' => 'form-control input-sm','required')) !!}
                        </div>
                    </div>
                    <div class="form-group col-sm-12 col-xs-12">
                        <div class="col-sm-3 col-xs-12 ">
                            <label class="required" for="name">{{__('administrator.cv')}}</label>
                        </div>
                        <div class="col-sm-8">
                            {!! Form::file('cv', array('requrired')) !!}
                        </div>
                    </div>
                    <div class="col-sm-11 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class=" button_primary pull-right">
                                <span class="fa fa-save"></span> {{__('administrator.apply')}}
                            </button>
                            {{-- <button type="button" onClick="javascript:history.go(-1)" class=" button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span>{{__('administrator.back')}}
                            </button> --}}
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    @endif
</div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
    <script src="{{asset('js/select2/select2.min.js')}}"></script>
    <script src="{{asset('js/select2/select2.min.js')}}"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            $('select').select2();  
        });  
    </script>
</html>