@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.in_external_training")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.in_external_training")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-in-external-training.store','method'=>'POST')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.employee')}}</strong>
                                        {!! Form::select('emp[]',$emp, null, array('class' => 'form-control select2','multiple' => 'multiple','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.training_course')}}</strong>
                                        {!! Form::select('training_course_id', $training_course, null, array('placeholder' => __('administrator.please_select'), 'class' => 'form-control select2','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.internal_lecturer')}}</strong>
                                        {!! Form::select('internal_lecturer_id', $emp, null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.external_lecturer')}}</strong>
                                        {!! Form::select('external_lecturer_id', $external_lecturer, null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
        
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.start_date')}}</strong>
                                        {!! Form::text('start_date',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.end_date')}}</strong>
                                        {!! Form::text('end_date',null, array('class' => 'form-control date_picker','autocomplete'=> 'off','required')) !!}
                                    </div>
                                </div>
        
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.time_in')}}</strong>
                                        <div class="bootstrap-timepicker">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    {!! Form::text('time_in', null,array('class' => 'form-control timepicker')) !!}
                                                    <div class="input-group-addon">
                                                    <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class="required"  for="name">{{__('administrator.time_out')}}</strong>
                                        <div class="bootstrap-timepicker ">
                                            <div class="form-group">
                                                <div class="input-group">
                                                    {!! Form::text('time_out', null,array('class' => 'form-control timepicker')) !!}
                                                    <div class="input-group-addon">
                                                    <i class="fa fa-clock-o"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
        
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.training_cost')}}</strong>
                                        {!! Form::text('training_cost',null, array('class' => 'form-control number-only','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-3 col-xs-3">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.score')}}</strong>
                                        {!! Form::text('score',null, array('class' => 'form-control number-only','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.location')}}</strong>
                                        {!! Form::text('location',null, array('class' => 'form-control','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-12">
                                        <strong class=""  for="name">{{__('administrator.description')}}</strong>
                                        {!! Form::text('description',null, array('class' => 'form-control','autocomplete'=> 'off')) !!}
                                    </div>
                                </div>
        
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection



