@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.external_lecturer')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.external_lecturer')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.Create New")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-external-lecturer.store','method'=>'POST')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.khmer_name')}}</label>
                                    {!! Form::text('full_name_kh',null, array('placeholder' => __('administrator.khmer_name') ,'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.english_name')}}</label>
                                    {!! Form::text('full_name_en',null, array('placeholder' => __('administrator.english_name') ,'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.trainer_type')}}</label>
                                    {!! Form::select('trainer_type',
                                                    ['full_time' =>'Full TIME',
                                                    'freelancer' => 'Freelancer',
                                                    'termination'=> 'Termination'], null,
                                                        array('class' => 'form-control select2','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.phone')}}</label>
                                    {!! Form::text('phone',null, array('placeholder' => __('administrator.phone') ,'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.email')}}</label>
                                    {!! Form::email('email',null, array('placeholder' => __('administrator.email') ,'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
        
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.address')}}</label>
                                    {!! Form::text('address',null, array('placeholder' => __('administrator.address') , 'class' => 'form-control','autocomplete'=> 'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-3 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.experties')}}</label>
                                    {!! Form::text('expertise',null, array('placeholder' => __('administrator.expertise') ,'class' => 'form-control','autocomplete' => 'off','required')) !!}
                                    
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection



