@extends("layouts.master")

@section('content')
    @include('hr.employee-promote.confirm-delete')
    @include('hr.employee-promote.modal-show')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.promotion")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.promotion")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.code')}}</th>
                                        <th>{{__('administrator.english_name')}}</th>
                                        <th>{{__('administrator.khmer_name')}}</th>
                                        <th>{{__('administrator.branch')}}</th>
                                        <th>{{__('administrator.department')}}</th>
                                        <th>{{__('administrator.position')}}</th>
                                        <th>{{__('administrator.increment_date')}}</th>
                                        <th>{{__('administrator.basic_salary')}}</th>
                                        <th>{{__('administrator.increment_salary')}}</th>
                                        <th>{{__('administrator.reason')}}</th>
                                        <th style="width: 200px;">{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn-view', function(){
                var id = $(this).data('id');
                var route = "{{route('hr.show-promote',':id')}}";
                route = route.replace(':id', id);
                $.ajax({
                    url: route,
                    type: 'GET',
                    data: {
                        _token: "{{csrf_token()}}",
                        id: id
                    },
                    success: function(data){
                        var old_date    = data.increment_date ? data.increment_date : "";
                        var arr         = old_date.split('-');
                        var new_date    = arr[2]+'-'+arr[1]+'-'+arr[0];

                        var branch          = data.get_branch != null ? data.get_branch.english_name : "";
                        var department      = data.get_department != null ? data.get_department.english_name : "";
                        var position        = data.get_position != null ? data.get_position.english_name : "";

                        $('#code').val(data.code);
                        $('#khmer_name').val(data.name_kh);
                        $('#english_name').val(data.name);
                        $('#branch').val(branch);
                        $('#department').val(department);
                        $('#position').val(position);
                        $('#increment_date').val(new_date);
                        $('#basic_salary').val(data.basic_salary);
                        $('#increment_salary').val(data.increment_salary);
                        $('#reason').val(data.reason);
                        $('#form-show').modal('show');
                    },
                    error: function(e){
                        console.log('error');
                    }
                });
            });
            $(document).on('click','.btn-delete-promote', function(){
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 30, 50, 100, 1000], [20, 30, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-emp-promote') }}",
                columns:
                    [
                        {
                            data: 'DT_RowIndex', 
                            searchable: false
                        },
                        {
                            data: 'code'
                        },
                        {
                            data: 'name_kh'
                        },
                        {
                            data: 'name'
                        },
                        {
                            data: 'branch_id'
                        },
                        {
                            data: 'department_id'
                        },
                        {
                            data: 'position_id'
                        },
                        {
                            data: 'increment_date'
                        },
                        {
                            data: 'basic_salary'
                        },
                        {
                            data: 'increment_salary'
                        },
                        {
                            data: 'reason'
                        },
                        {
                            data: 'action', 
                            searchable: false
                        },
                    ],
                "initComplete": function (settings, json) {
                }
            });
            
            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
