@extends("layouts.master")

@section('content')
    @include('hr.employee-loan.confirm-delete')
    <?php Fun::lang()?>

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.loan")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.loan")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Loan Create')
                                    <a class="btn btn-sm btn-success" href="{{route('hr-emp-loan.create')}}"><span class="fa fa-plus"></span> {{__("administrator.create_new")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_products" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.employee')}}</th>
                                        <th>{{__('administrator.loan_type')}}</th>
                                        <th>{{__('administrator.amount')}}</th>
                                        <th>{{__('administrator.date')}}</th>
                                        <th>{{__('administrator.interest')}}</th>
                                        <th>{{__('administrator.duration')}}</th>
                                        <th>{{__('administrator.start_date')}}</th>
                                        <th>{{__('administrator.end_date')}}</th>
                                        <th>{{__('administrator.disbursement')}}</th>
                                        <th>{{__('administrator.remark')}}</th>
                                        <th>{{__('administrator.action')}}</th>
                                    </tr>
                                </thead>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {
            $(document).on('click', '.btn-delete-loan', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });
            $('#datatable_products').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{route('datatable.hr-get-emp-loan')}}",
                columns:
                    [
                        {data: 'DT_RowIndex', searchable: false},
                        {data: 'employee_name'},
                        {data: 'type_loan'},
                        {data: 'amount'},
                        {data: 'date'},
                        {data: 'interest'},
                        {data: 'duration'},
                        {data: 'start_date'},
                        {data: 'end_date'},
                        {data: 'disbursement'},
                        {data: 'remark'},
                        {data: 'action', searchable: false}
                    ],
                "initComplete": function (setting, json) {

                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
