@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__('administrator.development_plan')}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__('administrator.development_plan')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($dev, ['method' => 'PATCH','route' => ['hr-development-plan.update', $dev->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.employee')}}</label>
                                    {!! Form::select('emp_id', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-6 col-xs-12">
                                    <label class="required"  for="name">{{__('administrator.request_to')}}</label>
                                    {!! Form::select('request_to', $emp ,null, array('placeholder' => __('administrator.please_select'),'class' => 'form-control select2','autocomplete'=>'off','required')) !!}
                                    
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <label class=""  for="name">Area an need of Department</label>
                                    {!! Form::textarea('de_description' ,null, array('placeholder' => __('administrator.department'),'class' => 'form-control ','autocomplete'=>'off')) !!}
                                   
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.suggestion')}}</label>
                                    <table class="table table-bordered" width="100%;">
                                        <thead>
                                            <tr style="text-align: center;">
                                                <th>1. Training</th>
                                                <th>2. Hard Skill</th>
                                                <th>3. Soft Skill</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    @php
                                                        $suggestion_training    = $dev->suggestion_training;
                                                        $suggestion_hard_skill  = $dev->suggestion_hard_skill;
                                                        $suggestion_soft_skill  = $dev->suggestion_soft_skill;
                                                    @endphp
                                                    @foreach($training as $key => $value)
                                                        <input class="" type="checkbox" value="1" {{@$suggestion_training[$value->name]?'checked=true':''}} name="training[{{ $value->name }}]" >
                                                        <label>{{$value->name}}</label><br>
                                                    @endforeach
                                                </td>
                                                <td>
                                                    @foreach($hard_skill as $key => $value)
                                                        <input class="" type="checkbox" value="1" {{@$suggestion_hard_skill[$value->name]?'checked=true':''}} name="hard_skill[{{ $value->name }}]" >
                                                        <label>{{$value->name}}</label><br>
                                                    @endforeach
                                                </td>
                                                <td>
                                                    @foreach($soft_skill as $key => $value)
                                                        <input class="" type="checkbox" value="1"  {{@$suggestion_soft_skill[$value->name]?'checked=true':''}}  name="soft_skill[{{ $value->name }}]" >
                                                        <label>{{$value->name}}</label><br>
                                                    @endforeach
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="form-group col-sm-12 col-xs-12">
                                    <label class=""  for="name">{{__('administrator.description')}}</label>
                                    {!! Form::textarea('description' ,null, array('placeholder' => __('administrator.department'),'class' => 'form-control ','autocomplete'=>'off')) !!}
                                </div>
            
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("administrator.back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("administrator.save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

