@extends("layouts.master")

@section('content')
    <?php Fun::lang()?>
    @include('hr.department.confirm-delete')

    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.department")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.department")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>

        <section class="content">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="pull-left">
                                @can('Department Create')
                                    <a class="btn btn-sm btn-success create_branch" href="{{route('hr-department.create')}}"><span class="fa fa-plus"></span> {{__("application.Create New")}}</a>
                                @endcan
                            </div>
                        </div>
                        <div class="card-body">
                            <table id="datatable_department" width="100%" class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('administrator.code') }}</th>
                                        <th>{{__('administrator.khmer_name')}}</th>
                                        <th>{{__('administrator.english_name')}}</th>
                                        <th>{{__('administrator.note')}}</th>
                                        <th style="width: 200px">{{ __('administrator.action') }}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@section('js')
    <script type="text/javascript">
        $(document).ready(function () {

            $(document).on('click', '.btn_delete_department', function () {
                var id = $(this).data('id');
                $('#delete-id').val(id);
                $('#form-delete').modal('show');
            });

            $('#datatable_department').DataTable({
                ordering: false,
                serverSide: true,
                lengthMenu: [[20, 50, 100, 1000], [20, 50, 100, 1000]],
                ajax: "{{ route('datatable.hr-get-department') }}",
                columns:
                    [
                        {data: 'DT_RowIndex',orderable: false, searchable: false },
                        {data: 'code'},
                        {data: 'khmer_name'},
                        {data: 'english_name'},
                        {data: 'note'},
                        {data: 'action'},
                    ],
                "initComplete": function (settings, json) {
                }
            });

            $.fn.dataTable.ext.errMode = 'throw';
        });
    </script>
@endsection
