@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.edit")}} {{__("administrator.department")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__("administrator.manage_hr")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.department")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.edit")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($department, ['method' => 'PATCH','route' => ['hr-department.update', $department->id]]) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="required"  for="name">{{__('administrator.code')}}</label>
                                        {!! Form::text('code', null, array('placeholder' => __('administrator.code'),'class' => 'form-control','required')) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="required"  for="name">{{__('administrator.khmer_name')}}</label>
                                        {!! Form::text('khmer_name', null, array('placeholder' => __('administrator.khmer_name'),'class' => 'form-control','required')) !!}
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="required"  for="name">{{__('administrator.english_name')}}</label>
                                        {!! Form::text('english_name', null, array('placeholder' => __('administrator.english_name'),'class' => 'form-control','required')) !!}
                                    </div>
                                    <div class="form-group">
                                        <label class="" for="name">{{__('administrator.note')}}</label>
                                        {!! Form::textarea('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control no-resize','rows'=>'3')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
@endsection


    

