@extends("layouts.master")
@section('content')
    <?php Fun::lang()?>
    <div class="content-wrapper">
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("administrator.absent_policy")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("administrator.Dashboard")}}</a></li>
                            <li class="breadcrumb-item active">{{__('administrator.manage_hr')}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.absent_policy")}}</li>
                            <li class="breadcrumb-item active">{{__("administrator.create_new")}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </section>
        
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::open(array('route' => 'hr-absent-policy.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
                    <div class="card card-default">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <strong class="required"  for="name">{{__('administrator.name')}}</strong>
                                        {!! Form::text('name', null, array('placeholder' => __('administrator.name'),'class' => 'form-control', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong class="required"  for="name">{{__('administrator.deduct_money_day')}}</strong>
                                        {!! Form::text('deduct_money', null, array('placeholder' => __('administrator.deduct_money'),'class' => 'form-control', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <strong class="required"  for="name">{{__('administrator.date')}}</strong>
                                        {!! Form::text('date', null, array('placeholder' => __('administrator.date'),'class' => 'form-control date_picker', 'autocomplete'=>'off','required')) !!}
                                    </div>
                                    <div class="form-group">
                                        <strong class=""  for="name">{{__('administrator.note')}}</strong>
                                        {!! Form::text('note', null, array('placeholder' => __('administrator.note'),'class' => 'form-control', 'autocomplete'=>'off')) !!}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                            </div>
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </section>
    </div>
    
@endsection




