@extends("layouts.master")
@section("content")
@include('group-item.create')
@include('group-item.edit')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Group")}} {{__("application.Item")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item active">{{__("application.List")}} {{__("application.Group")}} {{__("application.Item")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Category-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="#category-add" data-toggle="modal"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-category" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
    function category_save(){
      var id=$("#category-id").val();
      var name=$("#category-name").val();
      if(name==''){
        $("#category-name").focus();
        $("#category-name").css("border","1px solid red");
      }
      else{
        $('.main-spinner').show();
        var des=$("#category-des").val();
        var route="{{route('group_item.update',':id')}}";
        route=route.replace(":id",id);
        $.ajax({
          url:route,
          type:"PATCH",
          dataType:"JSON",
          data:{
            "_token":"{{csrf_token()}}",
            "name":name,
            "des":des
          },
          success:function(data){
            $('.main-spinner').hide();
            $("#category-edit").modal("hide");
            window.location.reload();
          },
          error:function(){
            alert("NO");
          }
        });
      }
      
    }
    function edit_category(obj){
      if($(obj).closest("tr").hasClass("child")){
        var id=$(obj).closest('tr').prev().attr('id');
      }else{
        var id=$(obj).closest('tr').attr('id');
      }
      $('.main-spinner').show();
      $.ajax({
        url:"{{route('group_item.get_group_item')}}",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          'id':id
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#category-edit").modal("show");
          $("#category-id").val(data.id);
          $("#category-name").val(data.name);
          $("#category-des").val(data.description);
        },
        error:function(data){
          console.log("Eror");
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-category').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            "scrollY": screen.height,
            "scrollX": true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "{{ route('group_item.get_group_item') }}",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'name','name':'nso007_category_stock.name'},
                {data: 'description','name':'nso007_category_stock.description'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  
</script>
@endsection