@extends("layouts.master")
@section("content")
@include('customer.show')
@include('customer.change_to_client',compact('provinces'))
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Customer")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
              <li class="breadcrumb-item active">{{__("application.Customer")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('customer.create') }}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-customer" class="table table-bordered table-hover" width="100%">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Nick Name")}}</th>
                  <th>{{__("application.Gender")}}</th>
                  <th>{{__("application.Phone")}}</th>
                  <th>{{__("application.Type")}}</th>
                  <th>{{__("application.Address")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script>
    function set_inactive(id){
      $("#ag-id").val(id);
    }
    function processInactive(){
      $('.main-spinner').show();
      var id = $("#ag-id").val();
      $.ajax({
        type:"POST",
        dataType:"JSON",
        url:"{{route('agencies.set_to_inactive')}}",
        data:{
          "_token":"{{csrf_token()}}",
          "id":id
        },
        success:function(data){
          $('.main-spinner').hide();
          window.location.reload();
          toastr.success("Agency change to inactive successfully !");
        }
      });
    }
    function show_info(id){
      var route="{{route('customer.show',':id')}}";
      $('.main-spinner').show();
      route=route.replace(":id",id);
      $.ajax({
        url:route,
        type:"GET",
        dataType:"JSON",
        success:function(data){
          $('.main-spinner').hide();
          $("#ag-name").empty();
          $("#ag-name").append(data.name);
          if(data.name==null) 
            $(".show-name").hide();
          $("#ag-nick-name").empty();
          $("#ag-nick-name").append(data.nick_name);
          if(data.nick_name==null)
            $(".show-nick-name").hide();
          $("#ag-gender").empty();
          $("#ag-gender").append(data.gender);
          if(data.gender==null)
            $(".show-gender").hide();
          $("#ag-phone").empty();
          $("#ag-phone").append(data.phone);
          if(data.phone==null)
            $(".show-phone").hide();
          $("#ag-dob").empty();
          $("#ag-dob").append(data.date_of_birth);
          if(data.date_of_birth==null)
            $(".show-dob").hide();
          $("#ag-nation").empty();
          $("#ag-nation").append(data.nationality);
          if(data.nationality==null)
            $(".show-nation").hide();
          $("#ag-des").empty();
          $("#ag-des").append(data.description);
          if(data.description==null)
            $(".show-des").hide();
          $("#ag-type").empty();
          if(data.type==0)
            $("#ag-type").append("<p class='text-success'>Customer</p>"); 
          if(data.type==1)     
             $("#ag-type").append("<p class='text-success'>Client</p>");
          $("#ag-address").empty();
          $(".show-address").hide();
          var address="";
          if(data.house_number!=null) 
            {
               $(".show-address").show();
              address+=data.house_number;
            }
          if(data.street_number!=null) 
            {
              $(".show-address").show();
              address+=" "+data.street_number;
            }
          if(data.get_village['village_km']!=null) 
          {
            $(".show-address").show();
            address+="​ ភូមិ​​ "+data.get_village['village_km'];
          }
          if(data.get_commune['commune_km']!=null) 
          {
            $(".show-address").show();
            address+=",​ ឃុំ "+data.get_commune['commune_km'];
          }
          if(data.get_district['district_km']!=null) 
            {
              $(".show-address").show();
              address+=", ស្រុក"+data.get_district['district_km'];
            }
          if(data.get_province['province_km']!=null) 
            {
              $(".show-address").show();
              address+=", ខេត្ត"+data.get_province['province_km'];
            }
          $("#ag-address").append(address);
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-customer').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "{{ route('customer.datatable_get_customer') }}",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'name','name':'nso007_client.name'},
                {data: 'nick_name','name':'nso007_client.nick_name'}, 
                {data: 'gender','name':'nso007_client.gender'},  
                {data: 'phone','name':'nso007_client.phone'}, 
                {data: 'type','searchable': false}, 
                {data: 'address','name':'nso007_client.address'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  function changeStatus(obj){
    $('.main-spinner').show();
    var id=$(obj).attr("id");
    var state=$(obj).attr("state");
    console.log(state);
    var route = "{{route('user.update_status',':id')}}";
    route = route.replace(':id',id);
    $.ajax({
      type:"GET",
      dataType:"JSON",
      url:route,
      data:{
        '_token':"{{csrf_token()}}"
      },
      success:function(data){
        $('.main-spinner').hide();
        if(data=="OK"){
          $("#"+id).empty();
          if(state==1){
            $("#"+id).append('<i style="padding:4px 8px 4px 6px;margin-right: -38px !important;" class="bg-danger">OFF</i>');
            $("#"+id).attr("state","0");
          }else if(state==0){
            $("#"+id).append('<i style="padding:4px 10px 4px 8px;margin-left: -37px !important;" class="bg-success">ON</i>');
            $("#"+id).attr("state","1");
          }
          toastr.success("User change state successfully !");
        }
      }
    });
  }
  
</script>
@endsection