@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Using")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Using")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('usings.create')}}"> {{__("application.Create New")}}</a>
                 <a class="btn btn-md btn-info" href="{{route('usings.return_stock')}}"> {{__("application.Return")}} {{__("application.Stock")}}</a>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datatable-using" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th>{{__('application.No')}}</th>
                      <th>{{__('application.Date')}}</th>
                      <th>{{__('application.Project')}} {{__('application.Name')}}</th>
                      <th>{{__('application.Block')}} </th>
                      <th>{{__('application.Person')}} {{__('application.Use')}}</th>
                      <th>{{__('application.Description')}}</th>
                      <th>{{__('application.Action')}}</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
function view_delete(obj){
      var id = $(obj).attr("using_id");
      $.confirm({
          title:'Are you sure ?',
          content:' ',
          theme:'modern',
          buttons:{
              cancel:{
                  btnClass:'btn btn-primary',
                  text:'Cancel',
                  action:function () {

                  }
              },
              submit:{
                  btnClass:'btn btn-danger',
                  text:"Delete",
                  action:function () {
                          window.location.replace('{{route( "usings.delete") }}'+"?using_id="+id);
                  }
              },
          },
      });
  }
  $(document).ready(function() {
    $(document).ready(function() {
      $('#datatable-using').DataTable({
          ordering: false,    
          "serverSide": true,
          "scrollY": screen.height,
          "scrollX": true,
          "lengthMenu": [[20, 30, 50, 100,-1], [20, 30, 50, 100,'all']],
          ajax: "{{ route('usings.using_get_list') }}",
          columns: 
              [
                  {data: 'DT_RowIndex'}, 
                  {data: 'date'},
                  {data: 'project_name'},
                  {data: 'name'},
                  {data: 'person_use'},
                  {data: 'remark'},
                  {data: 'action'}
              ]

      });

      $.fn.dataTable.ext.errMode = 'throw';
  });

    $.fn.dataTable.ext.errMode = 'throw';
});
</script>
@endsection