@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Purchase")}} {{__("application.Detail")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Purchase")}} {{__("application.Detail")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-info btn-sm" onClick="javascript:history.go(-1)" style="color:white;"><span class="fa fa-reply"></span>  {{__('application.Back')}}</a>
              </div>
            </div>
            <div class="card-body">
              <table id="datatable-purchase-detail" class="table table-bordered table-hover">
                <thead>
                  <tr>
                      <th>{{__('application.No')}}</th>
                      <th>{{__('application.Product')}} {{__('application.Code')}}</th>
                      <th>{{__('application.Product')}} {{__('application.Name')}}</th>
                      <th>{{__('application.Unit')}} {{__('application.Name')}}</th>
                      <th>{{__('application.Category')}} {{__('application.Name')}}</th>
                      <th>{{__('application.Unit')}} {{__('application.Price')}}</th>
                      <th>{{__('application.Qty')}}</th>
                      <th>{{__('application.Amount')}}</th>
                      <th>{{__('application.Description')}}</th>
                      <th>{{__('application.Action')}}</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($purchase_details as $key=>$value)
                      <tr>
                          <td>{{$key+1}}</td>
                          <td>{{$value->pro_code}}</td>
                          <td>{{$value->pro_name}}</td>
                          <td>{{$value->unit_name}}</td>
                          <td>{{$value->pcat_name}}</td>
                          <td>${{number_format($value->unit_price,2)}}</td>
                          <td>{{$value->qty}}</td>
                          <td>${{number_format($value->amount,2)}}</td>
                          <td>{{$value->remark}}</td>
                          <td><button type="button" class="btn btn-sm btn-success" onclick="show_image({{ $value->id }})" title="Show Image"><i class="fa fa-eye"></i></button></td>
                      </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>  
  $(document).ready(function() {
      $('#datatable-purchase-detail').DataTable();
  });
  function show_image(purchase_stock_id){
    var route = "{{route('show_purchase_product_image',':id')}}";
    route = route.replace(":id",purchase_stock_id);
    $(".main-spinner").show();
    $.ajax({
      url:route,
      type:"GET",
      dataType:"JSON",
      async:false,
      success:function(data){
        $(".main-spinner").hide();
        if(data['status']==true){
          var opt = "";
          $.each(data['image'],function(index,value){
            opt += `<div class="col-md-12" width="100%" height="50%"><img src = "${value}" width="100%"></div>`;
          });
          $.confirm({
              title: 'Image',
              content:opt,
              onContentReady: function () {
                  var self = this;
                  /*this.setContentPrepend('<div>Prepended text</div>');*/
                  /*setTimeout(function () {
                      self.setContentAppend('<div>Appended text after 2 seconds</div>');
                  }, 2000);*/
              },
              columnClass: 'medium',
          });
        }
        else{

        }
      },
      error:function(){
        $(".main-spinner").hide();
          return "Erro !"
      }
    });
  }
</script>
@endsection