@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.Create")}} {{__("application.Product")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Construction Management")}}</li>
               <li class="breadcrumb-item active">{{__("application.Product")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(array('route' => 'product-construction.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Code")}}:</strong>
                                     {!! Form::text('pro_code', null, array('placeholder' =>__('application.Product')." ".__('application.Code'),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Name")}}:</strong>
                                     {!! Form::text('pro_name', null, array('placeholder' => __('application.Product')." ".__('application.Name'),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Product")}} {{__("application.Price")}}:</strong>
                                     {!! Form::text('pro_price', null, array('placeholder' => __('application.Price'),'class' => 'form-control')) !!}
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Category")}}</strong>
                                    {!! Form::select('pro_category_id',$category, null, array('class' => 'form-control select2')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Unit")}}</strong>
                                    {!! Form::select('pro_unit_id',$unit, null, array('class' => 'form-control select2')) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                                {!! Form::hidden('pro_qty',0, array('placeholder' => __('administrator.qty'),'class' => 'form-control','required','readonly')) !!}

                            </div>
                            <div class="col-md-12" id="image-list">
                              <div class="form-group image-container" style="float:left;">
                                  <strong>{{__("application.Photo")}}</strong>
                                  <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                  <div style="width: 154px;height: 100px;">
                                      <img src="{{asset('assets\img\defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                  </div>
                                  <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                  <label class="custom-file-upload">
                                      <input type="file" id="file-image-ageny" name="photo[]" onchange="previewImage(event)" />
                                      <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                  </label>
                              </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                        <br>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script>
function remove_photo(obj){
  $("#sub-container-image-"+obj).remove();
}
function add_more_image(){
  var count_index = $("#image-list").find("div.image-container").length +1;
  $("#image-list").append(` <div class="form-group image-container" style="float:left;" id = "sub-container-image-${count_index}">
                                <strong>{{__("application.Photo")}}</strong>
                                <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo-${count_index}">
                                <div style="width: 154px;height: 100px;">
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" id="image-field-${count_index}" style="width: 154px;height: 100px;border: 1px solid grey">
                                </div>
                                <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="remove_photo(${count_index})">{{__("application.Remove")}}</button>
                                <label class="custom-file-upload">
                                    <input type="file" id="file-image-ageny-${count_index}" name="photo[]" onchange="previewImageMulti(event,${count_index})" />
                                    <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                </label>
                            </div>`);
}
</script>
@endsection