@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Client Relationship")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
              <li class="breadcrumb-item"><a href="{{route('clientrelationship.index')}}">{{__("application.Client Relationship")}}</a></li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::model($client_relationship, ['method' => 'PATCH','route' => ['clientrelationship.update', $client_relationship->id],'enctype' => 'multipart/form-data']) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Name")}}:</strong>
                                    {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Phone")}}:</strong>
                                    {!! Form::text('phone', null, array('placeholder' => __("application.Phone"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Nationality")}}:</strong>
                                    {!! Form::text('nationality', null, array('placeholder' => __("application.Nationality"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.ID Card Date")}}:</strong>
                                    {!! Form::text('id_card_date', null, array('class' => 'form-control date_picker','placeholder'=>__("application.ID Card Date"))) !!}
                                </div>
                                <!-- /.form-group -->
                                <div class="form-group">
                                    <strong>{{__("application.Email")}}:</strong>
                                    {!! Form::text('email', null, array('placeholder' => __("application.Email"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Job")}}:</strong>
                                    {!! Form::text('job', null, array('placeholder' => __("application.Job"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.House")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('house_number', null, array('placeholder' =>__("application.House")." ".__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Province")}}:</strong>
                                    {!! Form::select('province',$provinces,$client_relationship->province, array('class' => 'form-control select2','required','id'=>'p_province')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong class="required">{{__("application.Commune")}}:</strong>
                                    <select name="commune" id="p_commune" class="form-control select2" required>
                                        <option value="{{$client_relationship->commune}}" selected>{{$client_relationship->get_commune['commune_id']}} {{$client_relationship->get_commune['commune_en']}} {{$client_relationship->get_commune['commune_km']}}</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Village")}}:</strong>
                                    <select name="village" id="p_village" class="form-control select2" required>
                                        <option value="{{$client_relationship->get_village['village_id']}}">{{$client_relationship->get_village['village_id']}} {{$client_relationship->get_village['village_en']}} {{$client_relationship->get_village['village_km']}}</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Photo")}}</strong>
                                    <img src="{{asset('assets\img\defaultphoto.png')}}" style="display: none;" id="default-photo">
                                    <div style="width: 154px;height: 100px;">
                                        @if(!empty($client_relationship->image))
                                            <img src="{{asset('assets/img/upload/'.$client_relationship->image)}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @else
                                            <img src="{{asset('assets/img/defaultphoto.png')}}" id="image-field" style="width: 154px;height: 100px;border: 1px solid grey">
                                        @endif
                                        
                                    </div>
                                    <button type="button" class="btn btn-sm btn-danger" style="margin-top: -4px;" onclick="RemoveImage()">{{__("application.Remove")}}</button>
                                    <label class="custom-file-upload">
                                        <input type="hidden" name="cpImage" value="{{$client_relationship->image}}" id="cpImage">
                                        <input type="file" id="file-image-ageny" name="image" onchange="previewImage(event)" />
                                        <i class="fas fa-cloud-upload-alt"></i> {{__("application.Upload")}}
                                    </label>
                                </div>
                            <!-- /.form-group -->
                            </div>
                          <!-- /.col -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Nick Name")}}:</strong>
                                    {!! Form::text('nick_name', null, array('placeholder' => __("application.Nick Name"),'class' => 'form-control')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Gender")}}:</strong>
                                    {!! Form::select('gender', ["Male"=>"Male","Female"=>"Female"],[], array('class' => 'form-control select2','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.Date of Birth")}}:</strong>
                                    {!! Form::text('date_of_birth', null, array('class' => 'form-control date_picker','placeholder'=>__("application.Date of Birth"),'required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong class="required">{{__("application.ID Card")}}:</strong>
                                    {!! Form::text('id_card_number', null, array('placeholder' => __("application.ID Card"),'class' => 'form-control','required')) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.ID Card Date")}} {{__("application.Valid")}}:</strong>
                                    {!! Form::text('id_card_date_valid', null, array('class' => 'form-control date_picker','placeholder'=>__("application.ID Card Date")." ".__("application.Valid"))) !!}
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Work Place")}}:</strong>
                                    {!! Form::text('work_place', null, array('placeholder' => __("application.Work Place"),'class' => 'form-control')) !!}
                                </div>

                                <div class="form-group">
                                    <strong>{{__("application.Street")}} {{__("application.Number")}}:</strong>
                                    {!! Form::text('street_number', null, array('placeholder' => __("application.Street")." ".__("application.Number"),'class' => 'form-control')) !!}
                                </div>
                                
                                <div class="form-group">
                                    <strong class="required">{{__("application.District")}}:</strong>
                                    <select name="district" id="p_district" class="form-control select2" required>
                                        <option value="{{$client_relationship->get_district['district_id']}}" selected>{{$client_relationship->get_district['district_id']}} {{$client_relationship->get_district['district_en']}} {{$client_relationship->get_district['district_km']}}</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}</strong>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','placeholder'=>__("application.Description"),'rows'=>'5')) !!}
                                </div>
                            </div>
                            <div class="col-md-12">
                                &nbsp;
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script type="text/javascript">
    function RemoveImage(){
        var imageField = document.getElementById("image-field");
        var resource = document.getElementById("default-photo");
        var imge = document.getElementById("file-image-ageny");
        imge.value="";
        imageField.src = resource.src;
        document.getElementById("cpImage").value="";
    }
    function previewImage(event){
        var reader = new FileReader();
        var imageField = document.getElementById("image-field");
        reader.onload = function(){
            if(reader.readyState == 2){
                imageField.src = reader.result;
            }
        }

        reader.readAsDataURL(event.target.files[0]);
    }
</script>
@endsection