@extends("layouts.master")
@section("content")
@include('client.show')
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1> {{__("application.List")}} {{__("application.Client")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
               <li class="breadcrumb-item active">{{__("application.Manage Client")}}</li>
               <li class="breadcrumb-item active">{{__("application.Client")}}</li>
              <li class="breadcrumb-item active">{{__("application.Show")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Client-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{ route('client.create') }}"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-client" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{ __("application.Photo") }}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Name")}} {{__("application.Latin")}}</th>
                  <th>{{__("application.Nick Name")}}</th>
                  <th>{{__("application.Gender")}}</th>
                  <th>{{__("application.Phone")}}</th>
                  <th>{{__("application.Address")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script>
    function show_info(id){
      $('.main-spinner').show();
      var route="{{route('client.show',':id')}}";
      route=route.replace(":id",id);
      $.ajax({
        url:route,
        type:"GET",
        dataType:"JSON",
        success:function(data){
          $('.main-spinner').hide();
          $(".show-name").show();
          $("#client-name").empty();
          $("#client-name").append(data.name);
          if(data.name==null) 
            $(".show-name").hide();
          $(".show-nick-name").show();
          $("#client-nick-name").empty();
          $("#client-nick-name").append(data.nick_name);
          if(data.nick_name==null)
            $(".show-nick-name").hide();
          $(".show-gender").show();
          $("#client-gender").empty();
          $("#client-gender").append(data.gender);
          if(data.gender==null)
            $(".show-gender").hide();
          $(".show-phone").show();
          $("#client-phone").empty();
          $("#client-phone").append(data.phone);
          if(data.phone==null)
            $(".show-phone").hide();
          $(".show-dob").show();
          $("#client-dob").empty();
          $("#client-dob").append(data.date_of_birth);
          if(data.date_of_birth==null)
            $(".show-dob").hide();
          $(".show-nation").show();
          $("#client-nation").empty();
          $("#client-nation").append(data.nationality);
          if(data.nationality==null)
            $(".show-nation").hide();
          $("#client-idcard").empty();
          $("#client-idcard").append(data.id_card_number);

          $(".show-idcard-date").show();
          $("#client-idcard-date").empty();
          $("#client-idcard-date").append(data.id_card_date);
          if(data.id_card_date==null)
            $(".show-idcard-date").hide();

          $(".show-idcard-date-valid").show();
          $("#client-idcard-date-valid").empty();
          $("#client-idcard-date-valid").append(data.id_card_date_valid);
            if(data.id_card_date_valid==null)
              $(".show-idcard-date-valid").hide();

          $(".show-email").show();
          $("#client-email").empty();
          $("#client-email").append(data.email);
          if(data.email==null)
            $(".show-email").hide();

          $(".show-job").show();
          $("#client-job").empty();
          $("#client-job").append(data.job);
          if(data.job==null)
            $(".show-job").hide();

          $(".show-work-place").show();
          $("#client-work-place").empty();
          $("#client-work-place").append(data.work_place);
          if(data.work_place==null)
            $(".show-work-place").hide();

          $(".show-des").show();
          $("#client-des").empty();
          $("#client-des").append(data.description);
          if(data.description==null)
            $(".show-des").hide();

          $("#client-address").empty();
          $(".show-address").hide();
           var resource="";
          if(data.image!=''){
            var resource="assets/img/upload/"+data.image;
            document.getElementById("image-field").src=resource;
          }else{
             document.getElementById("image-field").src="assets/img/defaultphoto.png";
          }
          var address="";
          if(data.house_number!=null) 
            {
               $(".show-address").show();
              address+=data.house_number;
            }
          if(data.street_number!=null) 
            {
              $(".show-address").show();
              address+=" "+data.street_number;
            }
          if(data.get_village['village_km']!=null) 
          {
            $(".show-address").show();
            address+="​ ភូមិ​​ "+data.get_village['village_km'];
          }
          if(data.get_commune['commune_km']!=null) 
          {
            $(".show-address").show();
            address+=",​ ឃុំ "+data.get_commune['commune_km'];
          }
          if(data.get_district['district_km']!=null) 
            {
              $(".show-address").show();
              address+=", ស្រុក"+data.get_district['district_km'];
            }
          if(data.get_province['province_km']!=null) 
            {
              $(".show-address").show();
              address+=", ខេត្ត"+data.get_province['province_km'];
            }
          $("#client-address").append(address);
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-client').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            "scrollY": screen.height,
            "scrollX": true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "{{ route('client.datatable_get_client') }}",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {"data": "image",
                  "render": function(data, type, row) {
                    return '<img src="' + data + '" border="0" width="150px" height="80px" class="img-rounded" align="center" />';
                  }
                },
                {data: 'name','name':'nso007_client.name'},
                {data: 'latin_name','name':'nso007_client.latin_name'},
                {data: 'nick_name','name':'nso007_client.nick_name'},  
                {data: 'gender','name': 'nso007_client.gender'},
                {data: 'phone','name':'nso007_client.phone'},  
                {data: 'address','name':'nso007_client.address'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  
</script>
@endsection