@extends("layouts.master")
@section("content")
@include('block.create',compact('project'))
@include('block.edit',compact('project'))
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.List")}} {{__("application.Block")}} </h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Manage POS Stock")}}</li>
              <li class="breadcrumb-item active">{{__("application.Block")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            @can('Zone-Create')
            <div class="card-header">
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="#block-add" data-toggle="modal"> {{__("application.Create New")}}</a>
              </div>
            </div>
            @endcan
            <!-- /.card-header -->
            <div class="card-body">
              <table id="datable-block" class="table table-bordered table-hover">
                <thead>
                <tr>
                  <th>{{__("application.No")}}</th>
                  <th>{{__("application.Name")}}</th>
                  <th>{{__("application.Project")}} {{__("application.Name")}}</th>
                  <th>{{__("application.Description")}}</th>
                  <th>{{__("application.Action")}}</th>
                </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript" src="{{asset('assets/js/location.js')}}"></script>
<script>
    function block_save(){
      $('.main-spinner').show();
      var id=$("#block-id").val();
      var name=$("#block-name").val();
      var des=$("#block-des").val();
      var project=$("#block-project").val();
      var route="{{route('block.update',':id')}}";
      route=route.replace(":id",id);
      $.ajax({
        url:route,
        type:"PATCH",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          "name":name,
          "description":des,
          'project':project
        },
        success:function(data){
          $('.main-spinner').hide();
          window.location.reload();
          toastr.success("Update successfully !");
        },
        error:function(){
          toastr.error("Error with your input.");
        }
      });
    }
    function edit_block(obj){
      if($(obj).closest('tr').hasClass("child")){
        var id=$(obj).closest('tr').prev().attr('id');
      }else{
        var id=$(obj).closest('tr').attr('id');
      }
      $('.main-spinner').show();
      $.ajax({
        url:"{{route('block.get_block')}}",
        type:"POST",
        dataType:"JSON",
        data:{
          "_token":"{{csrf_token()}}",
          'id':id
        },
        success:function(data){
          $('.main-spinner').hide();
          $("#edit-block").modal("show");
          $("#block-id").val(data['block'].id);
          $("#block-name").val(data['block'].name);
          $("#block-des").val(data['block'].description);
          var opt="";
          $.each(data['project'],function(index,val){
            if(val.id==data['block'].project_id){
              opt+=`<option value="${val.id}" selected>${val.name}</option>`;
            }else{
              opt+=`<option value="${val.id}">${val.name}</option>`;
            }
            
          });
          $("#block-project").empty();
          $("#block-project").append(opt);
        },
        error:function(data){
          console.log("Eror");
        }
      });
    }
    $(document).ready(function() {
        $('.main-spinner').show();
        $('#datable-block').DataTable({  
            "autoWidth": false,
            ordering: false,
            serverSide: true,
            "scrollY": screen.height,
            "scrollX": true,
            lengthMenu: [[20, 30, 50, 100,200,500,1000], [20, 30, 50, 100,200,500,1000]],
            ajax: "{{ route('block.get_block') }}",
            columns: 
            [
                {data: 'DT_RowIndex','searchable': false},
                {data: 'name','name':'nso007_block.name'},
                {data: 'project_name'},
                {data: 'description','name':'nso007_block.description'}, 
                {data: 'action','searchable': false}, 
            ],

            "initComplete": function(settings, json) {
                $('.main-spinner').hide();
            }
        });

        $.fn.dataTable.ext.errMode = 'throw';
    });
  
</script>
@endsection