@extends("layouts.master")
@section("content")
<div class="modal fade" id="input-date-print">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Date Print</h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <input type="text" id="date-print" class="form-control date_picker" value="{{date('d-m-Y')}}">
      </div>
      <div class="modal-footer justify-content-between">
        <a>&nbsp;</a>
        <button type="button" id="btn-to-print" class="btn btn-primary">OK</button>
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="/* min-height: 4390.14px; */">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Journal List")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Journal List")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <!-- /.card-header -->
            <div class="card-header">
                <div class="row mb-2">
                    <div class="col-sm-12 col-xs-12">
                        {!! Form::open(array('route' => 'voucher.print','method'=>'POST','id'=>'print-voucher')) !!}
                        <input type="hidden" name="voucher" id="voucher">
                        <div class="title-bar">
                            <button type="submit" class="float-right btn btn-xs btn-warning" data-toggle="tooltip" data-placement="top" title="Print Voucher" disabled="disabled" style="display: none;"><i class="fa fa-print" aria-hidden="true"></i></button>
                            {{-- <span class="btn-toggle btn btn-primary btn-xs float-right" style="margin-right: 5px"><i class="fa fa-caret-down"></i></span> --}}
                        </div>
                        {!! Form::close() !!}
                        <div class="toggle-div" style="display: none">
                            <div class="form-group row">
                                <div class="col-sm-3 col-xs-12">
                                    <label for="">Reference Number</label>
                                    <div class="form-group">
                                        <input type="text" name="reference_no" class="form-control ref_no" placeholder="Reference Number">
                                    </div>
                                </div>
                                <div class="form-group  col-sm-3 col-xs-12">
                                    <label>Select Chart Of Account</label>
                                    {!! Form::select('journal_code', $acc_code, null, ['class' => 'form-control select2','id'=>'journal_code']) !!}
                                </div>
                                <div class="form-group  col-sm-3 col-xs-12">
                                    <label>Select Project</label>
                                    {!! Form::select('journal_by_project', $projects, null, ['class' => 'form-control select2','id'=>'project_id']) !!}
                                </div>
                                <div class="col-sm-3 col-xs-12">
                                    <label for="">Start Date</label>
                                    <input type="text" class="form-control date_picker start_date">
                                </div>
                                <div class="col-sm-3 col-xs-12">
                                    <label for="">End Date</label>
                                    <input type="text" class="form-control date_picker end_date">
                                </div>
                                <div class="col-sm-12 col-xs-12" style="text-align: right">
                                    <button type="button" style="margin-top: 30px;" class="btn btn-warning" onclick="search_journal()"> Search <span class="fa fa-search"></span></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @can('Journal-Create')
              <div class="pull-left">
                <a class="btn btn-md btn-success" href="{{route('journal.create')}}"> {{__("application.Create New")}}</a>
              </div>
            @endcan
            </div>
            <div class="card-body">
                <table id="table_journal" class="table table-bordered table table-condensed table-hover">
                    <thead>
                        <tr>
                            <th><label for="checkall">
                                    <input type="checkbox" id="checkall">
                                </label>
                            </th>
                            <th>No</th>
                            <th>Journal Date</th>
                            <th>Project Name</th>
                            <th>Voucher Type</th>
                            <th>Voucher Number</th>
                            <th>Account Name</th>
                            <th>Reference Number</th>
                            <th>Description</th>
                            <th>Debit</th>
                            <th>Credit</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody id="tbody"></tbody>
                    <tfoot id="tfoot">
                        <tr>
                            <td colspan="9" class="text-right bold-green">Total </td>
                            <td class="bold-orange"></td>
                            <td class="bold-orange"></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <div class="modal fade bs-modal-lg" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                 <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
                <h3 class="modal-title text-danger">Warning...!</h3>
            </div>
            <br />
            <div class="row">
                <div class="col-md-12">
                    <div class="col-md-10">
                        <h4>Receivable amount must be smaller than or equal available amount.</h4>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="button_primary"><i class="fa fa-close"></i> Close</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
@include('accounting.journal.confirm-delete')
@endsection
@section('js')
<script src="{{asset('assets/js/journal.js')}}"></script>
<script type="text/javascript">

    $(document).ready(function () {
        $('#journal-del').on('click',function (e) {
            e.preventDefault();
            var id = $('#delete-id').val();
            $.ajax({
                url:"{{route('journal_confirm_delete')}}",
                type:"POST",
                dataType:"JSON",
                data:{
                    "_token": "{{ csrf_token() }}",
                    "delete_id" : id
                },
                success:function (data) {
                    $('#form-delete').modal('hide');
                    $('#table_journal').DataTable().ajax.reload();
                    toastr['success'](data['message']);
                },
                error:function (err) {
                    console.log(err);
                }
            });
        });
    });

    $(document).on("click","#btn-to-print",function(){
        $.ajax({
            url: '{{route("note_print_date")}}',
            type: 'POST',
            dataType: 'JSON',
            data: {
                date: $("#date-print").val(),
                "_token":"{{csrf_token()}}"
            },
        })
        .done(function() {
            $('button[type="submit"]').click();
        })
        .fail(function() {
            console.log("error");
        })
        .always(function() {
            console.log("complete");
        });
    });

    $(document).on("click","#print-report-accounting",function(){
        $("#input-date-print").modal("show");
    });

    // $(document).on('click', '.btn-toggle', function() {
    //     $('.toggle-div').toggle('fast');
    // });
    function search_report(obj){
        $('.toggle-div').toggle('fast');
    }
    var ArrId = [];
    $(document).on('change', '#checkall', function() {
        ArrId = [];
        if ($(this).is(':checked')) {
            $('button[type="submit"]').removeAttr('disabled');
            $('#print-report-accounting').removeAttr('disabled');
            $('.checkbox').each(function() {
                $(this).prop('checked', true);
                var id = $(this).attr('id');
                ArrId.push(id);
            });
        }
        else
            {
            $('button[type="submit"]').prop('disabled',true);
            $('#print-report-accounting').prop('disabled',true);
            $('.checkbox').each(function() {
                $(this).prop('checked', false);
                ArrId = [];
            });
        }
        push_data(ArrId);
    });
    $(document).on('change', '.checkbox', function() {
        var id = $(this).attr('id');
        if ($(this).is(':checked')) {
            $('button[type="submit"]').removeAttr('disabled');
            $('#print-report-accounting').removeAttr('disabled');
            ArrId.push(id);
        }
        else
        {
            $('button[type="submit"]').prop('disabled',true);
            $('#print-report-accounting').prop('disabled',true);
            var index = ArrId.indexOf(id);
            if (index > -1) {
                ArrId.splice(index, 1);
            }
        }
        push_data(ArrId);
    });
    $(document).on('click', '.btn-action', function() {
        $('#block-action').toggle("fast");
    });


    $("form").submit(function(e) {
        if (ArrId === undefined || ArrId.length == 0) {
            $.alert({
                title: 'Error',
                icon: 'fa fa-warning',
                type: 'orange',
                content: 'No fileds Selected' +
                    '<hr>' +
                    'Please Select Any Fields',
            });
            return false;
        }
    });

    function push_data(obj) {
        $('#voucher').val(obj);
    }

    function push_array(obj) {
        obj = [];
        $('.checkbox').each(function() {
            var id = $(this).attr('id');
            obj.push(id);
        });
        return obj;
    }

    function search_journal() {
        $('#tbody').empty();
        $('#tfoot').empty();
        var ref = $('.ref_no').val();
        var end_date = $('.end_date').val();
        var start_date = $('.start_date').val();
        var project_id = $('#project_id').val();
        var journal_code = $('#journal_code').val();
        var tr="";
        var total_debit = 0;
        var total_credit = 0;
        var btn_edit = '';
        var btn_delete = '';
        var check_edit = "<?php echo Gate::check('Journal-Edit'); ?>";
        var check_delete = "<?php echo Gate::check('Journal-Delete'); ?>";
            $.ajax({
                url: "{{ route('datatable.get-journal')}}",
                method: "POST",
                dataType: "json",
                data: {
                    ref: ref,
                    start_date: start_date,
                    end_date: end_date,
                    project_id: project_id,
                    journal_code: journal_code,
                    _token: '{{ csrf_token() }}',
                },
                success: function(data) {
                   if(data == '')
                   {
                       tr+=`<tr align="center"><td colspan="11">{{__('administrator.no_data')}}</td></tr>`;
                   }
                   else
                   {
                       $.each(data,function(index,val){
                           var route_edit = "{{route('journal.edit',':id')}}";
                           console.log(val.id);
                           route_edit = route_edit.replace(':id',val.id);
                           if(val.journal_status == 0)
                           {
                               btn_edit= `<a href="${route_edit}" class="btn btn-sm btn-success"><i class="fa fa-edit"></i></a>`;
                           }
                           if(val.journal_status == 0)
                           {
                               btn_delete = `<a href="#" data-id="${val.id}" data-toggle="modal" data-target="#form-delete" class="btn btn-sm btn-danger confirm_delete"><i class="fa fa-trash"></i></a>`;
                           }
                           total_credit+=val.journal_credit;
                           total_debit+=val.journal_debit;
                           var checkbox = `<label><input id="${val.id}" class="checkbox" type="checkbox"></label>`;
                           tr +=    `<tr>
                                        <td>${checkbox}</td>
                                        <td>${(index+1)}</td>
                                        <td>${val.journal_paydate}</td>
                                        <td>${val.project_name}</td>
                                        <td>${val.voucher_type}</td>
                                        <td>${val.voucher_ref}</td>
                                        <td>${val.account_code+' '+val.acc_name}</td>
                                        <td>${val.journal_invoice!=null?val.journal_invoice:""}</td>
                                        <td>${val.journal_des}</td>
                                        <td>${val.journal_debit}</td>
                                        <td>${val.journal_credit}</td>
                                        <td>${btn_edit} ${btn_delete}</td>
                                    </tr>`;
                       });
                   }
                    var footer =    `<tr>
                                        <td colspan="9" class="text-right bold-green">Total </td>
                                        <td class="bold-orange">$${parseFloat(total_debit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                        <td class="bold-orange">$${parseFloat(total_credit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                                        <td></td>
                                    </tr>`;
                    $('#tfoot').append(footer);
                    $('#tbody').append(tr);
                }
            });
    }
   $(document).on('click','.confirm_delete',function () {
      var id = $(this).data('id');
       $('#delete-id').val(id);
       $('#form-delete').modal('show');
   });
</script>
@endsection
