@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.A/P")}} {{__("application.Payment")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Account")}}</li>
              <li class="breadcrumb-item"><a href="{{route('account_receiveable.index')}}">{{__("application.A/R")}} {{__("application.List")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Create")}} {{__("application.A/R")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::open(array('route' => 'account_payable.save_pay','method'=>'POST')) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
						            <input type="hidden" name="acc_payable_id" value="{{ $id }}">
                        <div class="row">
							            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Date")}}:</strong>
                                    {!! Form::text('journal_paydate',date("d-m-Y"), array('class' => 'form-control date_picker','placeholder'=>'Date','required')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                              <div class="form-group">
                                  <strong>{{__("application.Pay")}} {{__("application.To")}}:</strong>
                                  {!! Form::text('person_name',null, array('class' => 'form-control','placeholder'=>'Name')) !!}
                              </div>
                          </div>
                          <!-- /.col -->
                        </div>
                        <div class="row">
                          <!-- /.col -->
							<div class="col-md-6">
								<div class="form-group">
									<strong class="required">{{__("application.balance_amount")}}($):</strong>
									{!! Form::number('balance_amount',($data->journal_credit - $data->payable_paid), array('class' => 'form-control','placeholder'=>'Amount','required','step'=>'any','readonly')) !!}
								</div>
							</div>
                          	<div class="col-md-6">
								<div class="form-group">
									<strong class="required">{{__("application.Amount")}}($):</strong>
									{!! Form::number('amount',null, array('class' => 'form-control','placeholder'=>'Amount','required','step'=>'any')) !!}
								</div>
                        	</div>
                        </div>
                        <div class="row">
							<div class="col-md-6">
                                <div class="form-group">
									<strong class="required">{{__("application.Cash")}} {{__("application.Type")}}:</strong>
									{!! Form::select('cash_type',\Globals::cash_type(),null, array('class' => 'form-control select2','placeholder'=>'Please Select','required')) !!}
								</div>
                            </div>
							<div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Account")}} {{__("application.Name")}} 
                                      {{-- (<a href="#create-account-chart" data-toggle="modal">new account</a>) --}}
                                    :</strong>
                                    {!! Form::select('journal_acccode',\Globals::get_account_code(5),null, array('class' => 'form-control select2','required')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
						<div class="row">
							<div class="col-md-12">
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}:</strong>
                                    {!! Form::textarea('description',null, array('class' => 'form-control','placeholder'=>'Description','rows'=>'3','cols'=>'10')) !!}
                                </div>
                            </div>
						</div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success btn-submit" style="display: none;"><i class="far fa-save"></i> {{__("application.Save")}}</button>
							<button type="button" class="btn btn-sm btn-success" onclick="check_submit(this)"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    function check_submit(obj){
		let balance_amount = Number($("input[name=balance_amount]").val());
		let amount = Number($("input[name=amount]").val());
		if(amount<=balance_amount&&amount>0){
			$("button.btn-submit").click();
		}else{
			toastr.warning("Amount invalid !");
		}
	}
</script>
@endsection