@extends("layouts.master")
@section("content")
<style>
    input[type="file"] {
    display: none;
    }
    .custom-file-upload {
        border: 1px solid #497CB4;
        background: #497CB4;
        display: inline-block;
        padding: 2.5px 5px;
        cursor: pointer;
        color:white;
        border-radius: 3px;
        margin-top: 1px;
    }
</style>
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.A/P")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Account")}}</li>
              <li class="breadcrumb-item"><a href="{{route('account_payable.index')}}">{{__("application.A/P")}} {{__("application.List")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.A/P")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            <!-- SELECT2 EXAMPLE -->
            {!! Form::model($data, ['method' => 'PATCH','route' => ['account_payable.update', $data->id],'enctype'=>'multipart/form-data']) !!}
                <div class="card card-default">
                  <!-- /.card-header -->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Account")}} {{__("application.Name")}}:</strong>
                                    {!! Form::select('journal_acccode',$acc_code,null, array('class' => 'form-control select2','required')) !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Project")}}:</strong>
                                    {!! Form::select('journal_by_project',\Globals::get_project(),null, array('class' => 'form-control select2','required')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Date")}}:</strong>
                                    {!! Form::text('journal_paydate',date("d-m-Y",strtotime($data->journal_paydate)), array('class' => 'form-control date_picker','placeholder'=>'Date','required')) !!}
                                </div>
                            </div>
                            {{-- <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Name")}}:</strong>
                                    {!! Form::text('person_name',null, array('class' => 'form-control','placeholder'=>'Name')) !!}
                                </div>
                            </div> --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong class="required">{{__("application.Amount")}}($):</strong>
                                    {!! Form::number('journal_credit',null, array('class' => 'form-control','placeholder'=>'Amount','required','step'=>'any')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                                <strong>{{__("application.Supplier")}}:</strong>
                                {!! Form::select('journal_by_supplier',\Globals::get_supplier(),null, array('class' => 'form-control select2','placeholder'=>'Please Select')) !!}
                            </div>
                          </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <strong>{{__("application.Description")}}:</strong>
                                    {!! Form::textarea('description',$data->journal_des, array('class' => 'form-control','placeholder'=>'Description','rows'=>'3','cols'=>'10')) !!}
                                </div>
                            </div>
                          <!-- /.col -->
                        </div>
                        <!-- /.row -->
                    </div>
                  <!-- /.card-body -->
                    <div class="card-footer">
                        <div style="text-align: right;">
                            <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> {{__("application.Back")}}</button>
                            <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> {{__("application.Save")}}</button>
                        </div>
                    </div>
                </div>
            <!-- /.card -->
            {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    
</script>
@endsection