

@extends("layouts.master")
@section("content")
<!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>{{__("application.Edit")}} {{__("application.Account Chart")}}</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
              <li class="breadcrumb-item"><a href="{{route('account-chart.index')}}">{{__("application.Account Chart")}}</a></li>
              <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Account Chart")}}</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-12">
            {!! Form::model($account_chart, ['method' => 'PATCH','route' => ['account-chart.update', $account_chart->id],'enctype'=>'multipart/form-data','id' => 'form-acc']) !!}
            <?php //dd(); ?>
            <div class="card card-default">
                <div class="card-body">
{{--                    <div class="form-group row">--}}
{{--                        <div class="col-sm-4 col-12">--}}
{{--                            <label for="name" class="required">{{__('application.Account Type')}}</label>--}}
{{--                            <input type="text" name="acctype" value="{{$acc_type}}" class="form-control" readonly>--}}
{{--                        </div>--}}
{{--                        <div class="col-sm-4 col-12">--}}
{{--                            <label class="required">{{__('application.Account Type')}} {{__('application.Name')}}</label>--}}
{{--                            <input type="text" class="form-control" value="{{$acc_type_name}}" readonly>--}}
{{--                --}}{{--            {!! Form::select('acc_type_name', $sub_acc_type, $acc_type_name->id,['class' => 'form-control select2','id'=>'acc-type','required']) !!}--}}
{{--                        </div>--}}
{{--                        <div class="col-sm-4 col-12">--}}
{{--                            <label>Sub Account Of</label>--}}
{{--                            <input type="text" value="{{$sub_acc_of}}" readonly class="form-control">--}}
{{--                --}}{{--            @if($sub_acc !=null)--}}
{{--                --}}{{--                <select class="form-control select2" name="accounttype" id="sub-account-type">--}}
{{--                --}}{{--                    <option value="{{$sub_acc->id}}">{{$sub_acc_of}}</option>--}}
{{--                --}}{{--                </select>--}}
{{--                --}}{{--            @else--}}
{{--                --}}{{--            <select class="form-control select2" name="accounttype" id="sub-account-type" disabled="disabled"></select>--}}
{{--                --}}{{--            @endif--}}
{{--                        </div>--}}
{{--                    </div>--}}
                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label for="name" class="required">{{__("application.Account Type")}}</label>
                            {!! Form::select('acctype',$account_type,$sub_acc_type->acctype, array('class' => 'form-control select2','required','id'=>'account-type')) !!}
                        </div>
                        <div class="col-sm-4 col-12">
                            <label class="required">{{__("application.Account Type")}} {{__("application.Name")}}</label>
                            <input type="hidden" value="{{$account_current->id}}" id="acc_curr">
                            <input type="hidden" value="{{$account_current->acc_name}}" id="acc_name">
                            <select class="form-control select2" id="acc-type" name="acc_type_name" required></select>
                        </div>
                        <div class="col-sm-4 col-12">
                            <input type="checkbox" class="form-check-input " id="acc-check" {{!empty($sub_acc_of)? 'checked': ''}}>
                            <input type="hidden" value="{{$sub_acc->id}}" id="sub_acc_curr">
                            <input type="hidden" value="{{$sub_acc->acc_name}}" id="sub_acc_name">
                            <label>Sub Account Of </label>
                            <select class="form-control select2" name="accounttype" id="sub-account-type" ></select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-4 col-12">
                            <label>{{__('application.Account')}} {{__('application.Number')}}</label>
                            <input type="text" class="form-control number-only" name="acc_num" id="acc_num" readonly value="{{$account_chart->id}}">
                        </div>
                        <div class="col-sm-4 col-xs-12 ">
                            <label for="name" class="required">Sub Account</label>
                            {!! Form::text('acc_name', null, array('placeholder' =>"Sub Account",'class' => 'form-control','required')) !!}
                        </div>
                        <div class="col-sm-4 col-xs-12">
                            <label for="name" class="required">Sub Account Khmer</label>
                            {!! Form::text('acc_namekh', null, array('placeholder' => 'Sub Account Khmer','class' => 'form-control')) !!}
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-sm-12 col-xs-12 ">
                            <label for="name" >{{__('application.Description')}}</label>
                            {!! Form::textarea('acc_des', null, array('placeholder' =>__('application.Description'),'class' => 'form-control','rows'=>'3')) !!}
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div style="text-align: right;">
                        <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> Back</button>
                        <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> Save</button>
                    </div>
                </div>
            </div>

        {!! Form::close() !!}
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection
@section('js')
<script type="text/javascript">
    $(document).ready(function() {
        var account_type = $('#account-type').val();
        var account_curr = $('#acc_curr').val();
        var acc_name = $('#acc_name').val();
        $.ajax({
            type:'GET',
            url:'/get-account-code/'+account_type,
            dataType:'json',
            data:
                {
                    'account_code':account_type
                },
            success:function (data) {
                $('.main-spinner').hide();
                $('#acc-type').empty();
                $('#acc-type').append('<option value="'+account_curr+'" selected>'+account_curr+' | '+ acc_name +'</option>');
                $.each(data['acc_chart'],function (i,val) {
                    $('#acc-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                });
            },
            error:function (err) {
                console.log(err);
            }
        });
        var account_type_cur = $('#acc_curr').val();
        var acc_type = $('#acc-type').val();
        var sub_account_curr = $('#sub_acc_curr').val();
        var sub_acc_name = $('#sub_acc_name').val();
        $.ajax({
            type:'GET',
            url:'/get-account-code/'+account_type_cur,
            dataType:'json',
            data:
                {
                    'account_code':account_type_cur,
                    'acc_type' : acc_type
                },
            success:function (data) {
                $('.main-spinner').hide();
                $('#sub-account-type').empty();
                $('#sub-account-type').append('<option value="'+sub_account_curr+'" selected>'+sub_account_curr+' | '+ sub_acc_name +'</option>');
                $.each(data['acc_chart'],function (i,val) {
                    $('#sub-account-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                });
                // $('#acc_num').val(data['acc_num']);
            },
            error:function (err) {
                console.log(err);
            }
        });
    });
    $('.errors').hide();
    $('#form-acc').validate({
        rules :
            {
                'acctype' : {required:true},
                'accounttype' : {required:true}
            },
        message :
            {
                'acctype' : '{{__('application.field_required')}}',
                'accounttype' : '{{__('application.field_required')}}'
            }
    });
    $(document).on('change','#account-type',function () {
        $('.main-spinner').show();
        var account_type = $(this).val();
        $.ajax({
            type:'GET',
            url:'/get-account-code/'+account_type,
            dataType:'json',
            data:
                {
                    'account_code':account_type
                },
            success:function (data) {
                $('.main-spinner').hide();
                $('#acc-type').empty();
                $('#acc-type').append('<option value="" disabled="disabled" selected>Please Select</option>');
                $.each(data['acc_chart'],function (i,val) {
                    $('#acc-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                });
            },
            error:function (err) {
                console.log(err);
            }
        });
    });
    $(document).on('change','#acc-type',function () {
        $('.main-spinner').show();
        var account_type = $(this).val();
        var acc_type = $(this).val();
        $.ajax({
            type:'GET',
            url:'/get-account-code/'+account_type,
            dataType:'json',
            data:
                {
                    'account_code':account_type,
                    'acc_type' : acc_type
                },
            success:function (data) {
                $('.main-spinner').hide();
                $('#sub-account-type').empty();
                $('#sub-account-type').append('<option value="" disabled="disabled" selected>Please Select</option>');
                $.each(data['acc_chart'],function (i,val) {
                    $('#sub-account-type').append('<option value="'+val.id+'">'+val.id + " | " + val.acc_name +'</option>');
                });
                $('#acc_num').val(data['acc_num']);
            },
            error:function (err) {
                console.log(err);
            }
        });
    });
    $(document).on("change",'#acc-check',function(){
        if(this.checked)
        {
            $('#sub-account-type').removeAttr('disabled');
            $('#sub-account-type').prop('required');
        }
        else
        {
            $('#sub-account-type').val(1).trigger('change.select2');
            $('#sub-account-type').prop('disabled',true);
        }
    });
</script>
@endsection
