@extends("layouts.master")
@section("content")
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{__("application.Edit")}} {{__("application.Account Chart")}}</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{route('home')}}">{{__("application.Dashboard")}}</a></li>
                            <li class="breadcrumb-item"><a href="{{route('account-chart.index')}}">{{__("application.Account Chart")}}</a></li>
                            <li class="breadcrumb-item active">{{__("application.Edit")}} {{__("application.Account Chart")}}</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-12">
                    {!! Form::model($result['data'], ['method' => 'PATCH','route' => ['account-chart.update', $result['data']->id],'enctype'=>'multipart/form-data','id' => 'form-acc']) !!}
<!--                    --><?php //dd($result['parent']); ?>
                    <div class="card card-default">
                        <div class="card-body">
                            <input type="hidden" value="{{$result['data']->acctype}}" id="data">
                            <input type="hidden" value="{{$result['parent']}}" id="parent">
                                <div class="form-group row">
                                    <div class="col-sm-4 col-12">
                                        <label for="name" class="required">{{__("application.Account Type")}}</label>
                                        {!! Form::select('acctype', $account_type, $result['data']->type_id, ['class' => 'form-control select2','id'=>'account-type','required']) !!}
                                    </div>
                                    <div class="col-sm-4 col-12">
                                        <label class="required">Sub Account Of </label>
                                        {!! Form::select('acc_type_name', [], $result['data']->acctype, ['class' => 'form-control select2','id'=>'acc-type','required']) !!}
{{--                                        <select class="form-control select2" id="acc-type" name="acc_type_name" required></select>--}}

                                    </div>
                                    <div class="col-sm-4 col-12">
                                        <label class="required">{{__('application.Account')}} {{__('application.Number')}}</label>
                                        {!! Form::text('code', null, array('placeholder' =>__('application.Number'),'class' => 'form-control','required')) !!}
                                    </div>
                                </div>

                                <div class="form-group row">

                                    <div class="col-sm-4 col-xs-12 ">
                                        <label for="name" class="required">Sub Account</label>
                                        {!! Form::text('acc_name', null, array('placeholder' =>__('application.Name'),'class' => 'form-control','required')) !!}
                                    </div>
                                    <div class="col-sm-4 col-xs-12">
                                        <label for="name" class="required">Sub Account Khmer</label>
                                        {!! Form::text('acc_namekh', null, array('placeholder' => __('application.Name Khmer'),'class' => 'form-control')) !!}
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-12 col-xs-12 ">
                                        <label for="name" >{{__('application.Description')}}</label>
                                        {!! Form::textarea('acc_des', null, array('placeholder' => __('application.Description'),'class' => 'form-control','rows'=>'3')) !!}
                                    </div>
                                </div>
                        <div class="card-footer">
                            <div style="text-align: right;">
                                <button type="button" class="btn btn-sm btn-info" onclick="window.history.go(-1)"><i class="fas fa-arrow-circle-left"></i> Back</button>
                                <button type="submit" class="btn btn-sm btn-success"><i class="far fa-save"></i> Save</button>
                            </div>
                        </div>
                    </div>

                    {!! Form::close() !!}
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
@endsection
<style>
    .select2-container .select2-selection--single {
        box-sizing: border-box;
        cursor: pointer;
        display: block;
        height: 38px !important;
        user-select: none;
        -webkit-user-select: none;
    }
</style>
@section('js')
    <script type="text/javascript">
        $(document).ready(function() {
            // alert($('#parent').val());
            $('select[name="acc_type_name"]').html($('#parent').val());
            $('select[name="acc_type_name"]').val($('#data').val());
            $('select[name="acc_type_name"]').select2({
                templateResult: function(data) {
                    if (!data.element) {
                        return data.text;
                    }
                    var $element = $(data.element);
                    var $wrapper = $('<span></span>');
                    $wrapper.addClass($element[0].className);
                    $wrapper.text(data.text);
                    return $wrapper;
                }
            });

        });


        $('.errors').hide();
        $('#form-acc').validate({
            rules :
                {
                    'acctype' : {required:true},
                    'accounttype' : {required:true}
                },
            message :
                {
                    'acctype' : '{{__('application.field_required')}}',
                    'accounttype' : '{{__('application.field_required')}}'
                }
        });
        $(document).on('change','#account-type',function () {
            var type_id = $(this).find('option:selected').val();
            var route = "{{route('account-type.show',':id')}}";
            route = route.replace(':id', type_id);
            $.ajax({
                type: 'get',
                url: route,
                async: false,
                success: function(response) {
                    $('#acc-type').html(response);

                    $('select[name="acc_type_name"]').select2({
                        templateResult: function(data) {
                            if (!data.element) {
                                return data.text;
                            }
                            var $element = $(data.element);
                            var $wrapper = $('<span></span>');
                            $wrapper.addClass($element[0].className);
                            $wrapper.text(data.text);
                            return $wrapper;
                        }
                    });
                }
            });

        });

        $(document).on("change",'#acc-check',function(){
            if(this.checked)
            {
                $('#sub-account-type').removeAttr('disabled');
                $('#sub-account-type').prop('required');
            }
            else
            {
                $('#sub-account-type').val(1).trigger('change.select2');
                $('#sub-account-type').prop('disabled',true);
            }
        });
    </script>
@endsection
